/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.AppLogger;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

public class OpenTelnetConsole {
    private static final Logger LOGGER = AppLogger.getLogger(OpenTelnetConsole.class.getName());
    private static final File JAVA_CONSOLE_APPLICATION = new File(Constants.TEMP_DIRECTORY + File.separator + "JniorConsoleApplication.jar");
    private final String _host;

    public OpenTelnetConsole(String host) {
        this._host = host;
    }

    public void execute() {
        try {
            LOGGER.info(String.format("is windows: %s", Boolean.toString(Constants.IS_WINDOWS)));
            File javaConsoleApplication = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, "JniorConsoleApplication.jar"));
            LOGGER.info(String.format("%s exists: %s", javaConsoleApplication, String.valueOf(javaConsoleApplication.exists())));
            boolean found = javaConsoleApplication.exists();
            if (!found) {
                CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
                URL codeSourceLocation = codeSource.getLocation();
                URI executableUri = codeSourceLocation.toURI();
                String executingFilePath = new File(executableUri).getParentFile().getPath();
                javaConsoleApplication = new File(PathUtils.combine(executingFilePath, "JniorConsoleApplication.jar"));
                LOGGER.info(String.format("%s exists: %s", javaConsoleApplication, String.valueOf(javaConsoleApplication.exists())));
                found = javaConsoleApplication.exists();
            }
            if (!found) {
                javaConsoleApplication = new File(Constants.TEMP_DIRECTORY + File.separator + "JniorConsoleApplication-" + (int)(Math.random() * 100.0) + ".jar");
                LOGGER.info(String.format("%s exists: %s", JAVA_CONSOLE_APPLICATION, String.valueOf(JAVA_CONSOLE_APPLICATION.exists())));
                if (!JAVA_CONSOLE_APPLICATION.exists()) {
                    LOGGER.info(String.format("extracting %s", javaConsoleApplication));
                    ResourceUtils.extractResource("/resources/JniorConsoleApplication.jar", javaConsoleApplication);
                    LOGGER.info(String.format("extracted %s", javaConsoleApplication));
                    found = javaConsoleApplication.exists();
                }
            }
            if (found) {
                String javaConsoleFilePathString = javaConsoleApplication.getPath();
                ArrayList<String> cmdArrayList = new ArrayList<String>();
                String javaHome = System.getProperty("java.home");
                Collections.addAll(cmdArrayList, "java", "-jar", javaConsoleFilePathString);
                if (!"".equals(this._host)) {
                    cmdArrayList.add(this._host);
                }
                LOGGER.info("Working Directory = " + System.getProperty("user.dir"));
                String[] cmdArray = cmdArrayList.toArray(new String[cmdArrayList.size()]);
                String commandString = StringUtils.join(cmdArray, " ");
                LOGGER.info(String.format("%s", commandString));
                ProcessBuilder processBuilder = new ProcessBuilder(cmdArray);
                processBuilder.inheritIO();
                LOGGER.info(String.format("executing %s", javaConsoleApplication));
                processBuilder.start();
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error opening console", ex);
        }
    }
}

