/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.jmpprotocol.consolesession;

import com.integ.protocols.events.ConnectionEvent;
import com.integ.protocols.events.ConnectionListener;
import com.integ.protocols.events.JmpProtocolMessageListener;
import com.integ.protocols.events.JmpProtocolMessageReceivedEvent;
import com.integ.protocols.jmpprotocol.JmpProtocolClient;
import com.integ.protocols.jmpprotocol.consolesession.ConsoleSessionAuthenticationEvent;
import com.integ.protocols.jmpprotocol.consolesession.ConsoleSessionMessageEvent;
import com.integ.protocols.jmpprotocol.consolesession.ConsoleSessionMessageListener;
import com.integ.protocols.jmpprotocol.consolesession.ConsoleSessionPromptListener;
import com.integ.protocols.jmpprotocol.messages.ConsoleClose;
import com.integ.protocols.jmpprotocol.messages.ConsoleOpen;
import com.integ.protocols.jmpprotocol.messages.ConsoleStdIn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class ConsoleSession
implements ConnectionListener,
JmpProtocolMessageListener {
    private final Pattern PROMPT_PATTERN = Pattern.compile("[\\r?\\n]*([\\w-]*) (\\/\\w*)+> $");
    private final JmpProtocolClient _jmpProtocolClient;
    private final ArrayList<ConsoleSessionPromptListener> _promptListeners = new ArrayList();
    private final ArrayList<ConsoleSessionMessageListener> _messageListeners = new ArrayList();
    private boolean _isOpen;
    private boolean _isLoggedIn;
    private final Object _connectionLock = new Object();
    private final Object _promptLock = new Object();
    private final StringBuilder _response = new StringBuilder();
    private boolean _waitingForPrompt = false;
    private String _username;
    private String _password;
    private String _hostname = null;
    private Logger _logger = Logger.getGlobal();

    public ConsoleSession(JmpProtocolClient jmpProtocolClient) {
        this._jmpProtocolClient = jmpProtocolClient;
        this._jmpProtocolClient.addConnectionListener(this);
        this._jmpProtocolClient.addMessageListener(this);
        System.out.println(String.format("%s - new console session", this._jmpProtocolClient.toString()));
    }

    public ConsoleSession addPromptListener(ConsoleSessionPromptListener listener) {
        this._promptListeners.add(listener);
        return this;
    }

    public ConsoleSession addMessageListener(ConsoleSessionMessageListener listener) {
        this._messageListeners.add(listener);
        return this;
    }

    public String getHostname() {
        return this._hostname;
    }

    public boolean isLoggedIn() {
        return this._isLoggedIn;
    }

    @Override
    public void onConnecting(ConnectionEvent connectionEvent) {
    }

    @Override
    public void onConnected(ConnectionEvent connectionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosed(ConnectionEvent connectionEvent) {
        Object object = this._promptLock;
        synchronized (object) {
            this._promptLock.notify();
        }
    }

    @Override
    public void onError(ConnectionEvent connectionEvent, Exception ex) {
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(JmpProtocolMessageReceivedEvent event) {
        block17: {
            try {
                JSONObject jsonMessage = event.getJsonMessage();
                System.out.println(String.format("%s - console: %s", this._jmpProtocolClient.getClientString(), jsonMessage.toString()));
                String message = jsonMessage.getString("Message");
                if ("Console Response".equalsIgnoreCase(message)) {
                    String status = jsonMessage.getString("Status");
                    if ("Established".equalsIgnoreCase(status)) {
                        System.out.println(String.format("%s - console connection established", this._jmpProtocolClient.toString()));
                        Object object = this._connectionLock;
                        synchronized (object) {
                            this._isOpen = true;
                            System.out.println(String.format("%s - notify console connection lock", this._jmpProtocolClient.toString()));
                            this._connectionLock.notifyAll();
                            System.out.println(String.format("%s - console connection lock notified", this._jmpProtocolClient.toString()));
                            break block17;
                        }
                    }
                    if (!"Closed".equalsIgnoreCase(status)) break block17;
                    Object object = this._promptLock;
                    synchronized (object) {
                        this._promptLock.notifyAll();
                        break block17;
                    }
                }
                if (!"Console Stdout".equalsIgnoreCase(message)) break block17;
                String data = jsonMessage.getString("Data");
                if (data.contains(" login: ")) {
                    this.send(this._username + "\n");
                    break block17;
                }
                if (data.contains(" password: ")) {
                    this.send(this._password + "\n");
                    break block17;
                }
                if (data.contains("login failed")) break block17;
                this.alertMessageReceivedListeners(data);
                this._response.append(data);
                Matcher matcher = this.PROMPT_PATTERN.matcher(this._response.toString());
                if (!matcher.find()) break block17;
                this._hostname = matcher.group(1);
                System.out.println("Hostname: " + this._hostname);
                if (!this._isLoggedIn) {
                    this._isLoggedIn = true;
                }
                if (this._waitingForPrompt) {
                    int start = matcher.start();
                    this._response.setLength(start);
                    Object object = this._promptLock;
                    synchronized (object) {
                        this._promptLock.notifyAll();
                    }
                }
                this.alertPromptListeners();
            }
            catch (Exception ex) {
                this._jmpProtocolClient.fireErrorEvent(new ConnectionEvent(this._jmpProtocolClient), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this._connectionLock;
        synchronized (object) {
            System.out.println(String.format("%s - _isOpen: %s", this._jmpProtocolClient.getClientString(), String.valueOf(this._isOpen)));
            if (!this._isOpen) {
                try {
                    System.out.println(String.format("%s - send ConsoleOpen", this._jmpProtocolClient.getClientString()));
                    this._jmpProtocolClient.send(new ConsoleOpen());
                    System.out.println(String.format("%s - wait for console connection", this._jmpProtocolClient.getClientString()));
                    this._connectionLock.wait(5000L);
                    if (!this._isOpen) {
                        throw new RuntimeException("Console session not available");
                    }
                    System.out.println(String.format("%s - console connection opened", this._jmpProtocolClient.getClientString()));
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error opening console session", ex);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException("Error opening console session", ex);
                }
            }
        }
    }

    public void close() {
        if (this._isOpen) {
            try {
                this._jmpProtocolClient.send(new ConsoleClose());
            }
            catch (IOException ex) {
                throw new RuntimeException("Error closing console session", ex);
            }
        }
    }

    public void send(String data) {
        System.out.println(String.format("%s - send(%s)", this._jmpProtocolClient.getClientString(), data));
        if (!this._isOpen) {
            this.open();
        }
        try {
            this._jmpProtocolClient.send(new ConsoleStdIn(data));
        }
        catch (IOException ex) {
            throw new RuntimeException("Error sending to console session", ex);
        }
    }

    public String exec(String command) {
        return this.exec(command, 120000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec(String command, int timeout) {
        command = String.format("%s\n", command);
        Object object = this._promptLock;
        synchronized (object) {
            this._waitingForPrompt = true;
            this._response.setLength(0);
            this.send(command);
            try {
                this._promptLock.wait(timeout);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("prompt was not found in specified time", ex);
            }
            this._waitingForPrompt = false;
            return this._response.toString();
        }
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void setCredentials(String username, String password) {
        this._username = username;
        this._password = password;
    }

    private void alertMessageReceivedListeners(String message) {
        for (ConsoleSessionMessageListener messageListener : this._messageListeners) {
            ConsoleSessionMessageEvent promptEvent = new ConsoleSessionMessageEvent(this, message);
            messageListener.onMessage(promptEvent);
        }
    }

    private void alertPromptListeners() {
        for (ConsoleSessionPromptListener promptListener : this._promptListeners) {
            ConsoleSessionAuthenticationEvent promptEvent = new ConsoleSessionAuthenticationEvent(this);
            promptListener.onPrompt(promptEvent);
        }
    }
}

