/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon;

public class Version
implements Comparable<Version> {
    private static final int ALPHA = 0;
    private static final int BETA = 1;
    private static final int RELEASE_CANDIDATE = 2;
    private static final int RELEASED = 3;
    private String _versionString;
    private final int _major;
    private final int _minor;
    private final int _update;
    private final int _status;
    private final int _build;
    private final int _compile;
    private boolean _series4;

    public Version(boolean series4, int major, int minor, int update, int status, int build, int compile) {
        this._series4 = series4;
        this._major = major;
        this._minor = minor;
        this._update = update;
        this._status = status;
        this._build = build;
        this._compile = compile;
    }

    public static Version parse(String versionString) throws Exception {
        try {
            boolean series4;
            boolean bl = series4 = 'v' == versionString.charAt(0);
            if ('v' == versionString.charAt(0)) {
                versionString = versionString.substring(1);
            }
            int[] versionParts = new int[6];
            versionParts[PARSE_STATE.GET_STATUS.ordinal()] = 3;
            PARSE_STATE state = PARSE_STATE.GET_MAJOR;
            for (int i = 0; i < versionString.length(); ++i) {
                char c = versionString.charAt(i);
                if ('.' == c) {
                    state = PARSE_STATE.values()[state.ordinal() + 1];
                    continue;
                }
                if ('-' == c) {
                    state = PARSE_STATE.GET_STATUS;
                    continue;
                }
                if (PARSE_STATE.GET_STATUS == state) {
                    versionParts[state.ordinal()] = 'a' == c ? 0 : ('b' == c ? 1 : ('r' == c && 'c' == versionString.charAt(++i) ? 2 : 3));
                    state = PARSE_STATE.GET_BUILD;
                    continue;
                }
                versionParts[state.ordinal()] = versionParts[state.ordinal()] * 10 + (c - 48);
            }
            Version version = new Version(series4, versionParts[0], versionParts[1], versionParts[2], versionParts[3], versionParts[4], versionParts[5]);
            version._versionString = versionString;
            return version;
        }
        catch (Exception ex) {
            throw new Exception("Error parsing " + versionString, ex);
        }
    }

    public static Version getVersionFromBuildTag(String buildTag) {
        if (buildTag.startsWith("0x")) {
            buildTag = buildTag.substring(2);
        }
        long buildVersionNum = Long.parseLong(buildTag, 16);
        int major = (int)(buildVersionNum >> 44 & 0xFL);
        int minor = (int)(buildVersionNum >> 40 & 0xFL);
        int update = (int)(buildVersionNum >> 36 & 0xFL);
        int status = (int)(buildVersionNum >> 32 & 0xFL);
        int build = (int)(buildVersionNum >> 16 & 0xFFFFL);
        int compile = (int)(buildVersionNum & 0xFFFFL);
        Object buildTagVersionString = String.format("v%d.%d", major, minor);
        if (0 < update) {
            buildTagVersionString = (String)buildTagVersionString + "." + update;
        }
        String statusString = "";
        if (0 == status) {
            statusString = "-a";
        } else if (1 == status) {
            statusString = "-b";
        } else if (2 == status) {
            statusString = "-rc";
        } else if (3 == status) {
            statusString = " build ";
        }
        if (0 != build || 0 != compile) {
            buildTagVersionString = (String)buildTagVersionString + String.format("%s%d.%d", statusString, build, compile);
        }
        Version version = new Version(true, major, minor, update, status, build, compile);
        version._versionString = buildTagVersionString;
        return version;
    }

    public void setSeries4() {
        this._series4 = true;
    }

    public String toString() {
        return this._versionString;
    }

    @Override
    public int compareTo(Version v) {
        if (this._series4 != v._series4) {
            if (this._series4) {
                return 1;
            }
            if (!this._series4) {
                return -1;
            }
        }
        if (this._major > v._major) {
            return 1;
        }
        if (this._major < v._major) {
            return -1;
        }
        if (this._minor > v._minor) {
            return 1;
        }
        if (this._minor < v._minor) {
            return -1;
        }
        if (this._update > v._update) {
            return 1;
        }
        if (this._update < v._update) {
            return -1;
        }
        if (this._status > v._status) {
            return 1;
        }
        if (this._status < v._status) {
            return -1;
        }
        if (this._build > v._build) {
            return 1;
        }
        if (this._build < v._build) {
            return -1;
        }
        if (this._compile != v._compile) {
            if (this._compile > v._compile) {
                return 1;
            }
            if (this._compile < v._compile) {
                return -1;
            }
        }
        return 0;
    }

    public boolean isReleaseCandidate() {
        return 2 == this._status;
    }

    public boolean isAlpha() {
        return 0 == this._status;
    }

    public boolean isBeta() {
        return 1 == this._status;
    }

    private static enum PARSE_STATE {
        GET_MAJOR,
        GET_MINOR,
        GET_UPDATE,
        GET_STATUS,
        GET_BUILD,
        GET_COMPILE;

    }
}

