/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.ProjectStepPanel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FtpStep
extends ProjectStep {
    protected String _absoluteFile = "";
    protected String _localFile = "";
    protected String _remoteFolder = "";
    protected String _remoteFile = "";
    protected String _remotePath = "";
    protected String _md5 = "";
    protected boolean _updateAvailable = false;
    protected boolean _force = false;
    protected boolean _updated = false;

    public FtpStep(String name) {
        super(name);
        this._type = "LoadFtpProperty";
    }

    public FtpStep(Element xmlElement) {
        super(xmlElement);
        this._absoluteFile = this.getChildNodeString("AbsoluteFile");
        System.out.println("_absoluteFile = " + this._absoluteFile);
        this._localFile = this.getChildNodeString("LocalFile");
        System.out.println("LocalFile: " + this._localFile);
        this._remoteFolder = this.getChildNodeString("RemoteFolder");
        System.out.println("RemoteFolder: " + this._remoteFolder);
        this._remoteFile = this.getChildNodeString("RemoteFile");
        System.out.println("RemoteFile: " + this._remoteFile);
        this._remotePath = PathUtils.combine(this._remoteFolder, this._remoteFile);
        this._md5 = this.getChildNodeString("Md5");
        this._md5 = this._md5.toLowerCase();
        System.out.println("Md5: " + this._md5);
        this.checkForUpdate();
    }

    public final void checkForUpdate() {
        if (null != this._absoluteFile && new File(this._absoluteFile).exists()) {
            try {
                byte[] fileContentBytes = FileUtils.readAllBytes(this._absoluteFile);
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(fileContentBytes);
                byte[] digest = md.digest();
                String md5String = HexUtils.bytesToHex(digest).toUpperCase();
                this._updateAvailable = !md5String.equalsIgnoreCase(this._md5);
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
            }
        }
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element element = document.createElement("AbsoluteFile");
        element.appendChild(document.createTextNode(this._absoluteFile));
        xmlElement.appendChild(element);
        element = document.createElement("LocalFile");
        element.appendChild(document.createTextNode(this._localFile));
        xmlElement.appendChild(element);
        element = document.createElement("RemoteFolder");
        element.appendChild(document.createTextNode(this._remoteFolder));
        xmlElement.appendChild(element);
        element = document.createElement("RemoteFile");
        element.appendChild(document.createTextNode(this._remoteFile));
        xmlElement.appendChild(element);
        element = document.createElement("Md5");
        element.appendChild(document.createTextNode(this._md5));
        xmlElement.appendChild(element);
        return xmlElement;
    }

    public String getAbsoluteFilePath() {
        return this._absoluteFile;
    }

    public void setAbsoluteFilePath(String path) {
        String oldPath = this._absoluteFile;
        this._absoluteFile = path;
        this._changes.firePropertyChange("AbsoluteFilePath", oldPath, path);
    }

    public String getLocalFile() {
        return this._localFile;
    }

    public void setLocalFile(String localFile) {
        this._localFile = localFile;
    }

    public String getRemoteFolder() {
        return this._remoteFolder;
    }

    public void setRemoteFolder(String remoteFolder) {
        this._remoteFolder = remoteFolder;
        String oldPath = this._remotePath;
        this._remotePath = PathUtils.combine(this._remoteFolder, this._remoteFile);
        this._changes.firePropertyChange("RemotePath", oldPath, this._remotePath);
    }

    public String getRemoteFile() {
        return this._remoteFile;
    }

    public void setRemoteFile(String remoteFile) {
        this._remoteFile = remoteFile;
        String oldPath = this._remotePath;
        this._remotePath = PathUtils.combine(this._remoteFolder, this._remoteFile);
        this._changes.firePropertyChange("RemotePath", oldPath, this._remotePath);
    }

    public String getRemotePath() {
        return this._remotePath;
    }

    public String getMd5() {
        return this._md5;
    }

    void setMd5(String md5String) {
        String oldValue = this._md5;
        this._md5 = md5String.toLowerCase();
        this._changes.firePropertyChange("Md5", oldValue, this._md5);
    }

    public boolean isUpdateAvailable() {
        return this._updateAvailable;
    }

    @Override
    public boolean execute() throws Exception {
        this._updated = false;
        try {
            ZipEntry zipEntry;
            boolean result;
            this._logger.info("  target jnior series: " + this._jniorInfo.getSeries());
            if (!this._force) {
                if (4 == this._jniorInfo.getSeries()) {
                    this._logger.info(String.format("  checking to see if an update for %s is needed...", this._remotePath));
                    String manifestResponse = this._jniorUpdateControlConnection.exec("manifest " + this._remotePath);
                    this._logger.warning("      manifest response: " + manifestResponse);
                    Pattern md5Pattern = Pattern.compile("[\\da-g]{32}", 2);
                    Matcher matcher = md5Pattern.matcher(manifestResponse);
                    if (matcher.find()) {
                        String uploadedMd5 = matcher.group();
                        this._logger.info(String.format("  local md5: %s, remote md5: %s", this._md5, uploadedMd5));
                        if (this._md5.equalsIgnoreCase(uploadedMd5)) {
                            this._summary = String.format("  updating %s is not needed", this._remotePath);
                            this._logger.info(this._summary);
                            return true;
                        }
                    } else {
                        this._logger.warning("      md5 pattern was not found in " + manifestResponse);
                    }
                } else if (3 == this._jniorInfo.getSeries() && !"".equals(this._md5)) {
                    this._logger.info(String.format("  check to see if %s exists", this._remotePath));
                    String lsResponse = this._jniorUpdateControlConnection.exec(String.format("ls %s", this._remotePath));
                    boolean fileNotFound = lsResponse.toLowerCase().contains("no such");
                    if (!fileNotFound) {
                        this._logger.info(String.format("  download %s to determine if the upload is needed", this._remotePath));
                        File tempFile = File.createTempFile(this._remoteFile, "", new File(SupporterMain.TEMP_DIRECTORY));
                        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
                        result = this._jniorUpdateControlConnection.retrieveFile(this._remotePath, fileOutputStream);
                        if (result) {
                            byte[] byArray = FileUtils.readAllBytes(tempFile.getPath());
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            md.update(byArray);
                            byte[] digest = md.digest();
                            String newMd5String = HexUtils.bytesToHex(digest).toUpperCase();
                            this._logger.info(String.format("  remote file md5: %s", newMd5String));
                            if (newMd5String.equalsIgnoreCase(this._md5)) {
                                this._summary = String.format("  updating %s is not needed", this._remotePath);
                                this._logger.info(this._summary);
                                return true;
                            }
                        }
                    }
                }
            }
            if (null != (zipEntry = this._updateProjectFile.getEntryForFile(this._localFile))) {
                byte[] fileContentBytes = ZipUtils.extractEntry(this._updateProjectFile.getFilePath(), zipEntry.getName());
                String parentDirectoryListing = this._jniorUpdateControlConnection.exec("ls " + this._remoteFolder);
                if (parentDirectoryListing.toLowerCase().contains("no such")) {
                    String[] parts;
                    String path = "";
                    for (String part : parts = this._remoteFolder.split("/")) {
                        if ("".equals(part)) continue;
                        path = path + "/" + part;
                        String directoryListing = this._jniorUpdateControlConnection.exec("ls " + path);
                        if (!directoryListing.toLowerCase().contains("no such")) continue;
                        this._logger.info("Creating " + path);
                        this._jniorUpdateControlConnection.exec("mkdir " + path);
                        directoryListing = this._jniorUpdateControlConnection.exec("ls " + path);
                        if (!directoryListing.toLowerCase().contains("no such")) continue;
                        throw new Exception("Failed to create " + path);
                    }
                }
                this._logger.info(String.format("  upload %s to %s", this._localFile, this._remotePath));
                ByteArrayInputStream binaryInputStream = new ByteArrayInputStream(fileContentBytes);
                result = this._jniorUpdateControlConnection.storeFile(this._remotePath, binaryInputStream);
                if (result) {
                    this._summary = String.format("  uploaded %s to %s", this._localFile, this._remotePath);
                    this._logger.info(this._summary);
                }
                if (4 == this._jniorInfo.getSeries()) {
                    this._logger.info("    validating upload");
                    String string = this._jniorUpdateControlConnection.exec("manifest " + this._remotePath);
                    Pattern md5Pattern = Pattern.compile("[\\da-g]{32}", 2);
                    Matcher matcher = md5Pattern.matcher(string);
                    if (matcher.find()) {
                        String uploadedMd5 = matcher.group();
                        if (!this._md5.equalsIgnoreCase(uploadedMd5)) {
                            throw new RuntimeException("Upload failed");
                        }
                        this._logger.info("    upload verified");
                        this._updated = true;
                    }
                } else {
                    this._updated = true;
                }
                return result;
            }
        }
        catch (Exception ex) {
            this._logger.severe("unable to transfer " + this._localFile + ": " + ExceptionUtils.getStackTrace(ex));
        }
        return false;
    }
}

