/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.jtable;

import com.integ.supporter.ui.jtable.TableColumnAdjuster;
import com.integ.supporter.ui.jtable.TableColumnsListener;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ResizeColumnListener
implements MouseListener {
    private static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private MouseListener _uiListener;
    private final JTableHeader _header;
    private final TableColumnModel _tableColumnModel;
    private final TableColumnAdjuster _tableColumnAdjuster;
    private final int[] _columnWidths;
    private final ArrayList<TableColumnsListener> _tableColumnsListeners = new ArrayList();

    public ResizeColumnListener(JTable table) {
        MouseListener[] listeners;
        this._header = table.getTableHeader();
        this._tableColumnAdjuster = new TableColumnAdjuster(table);
        for (MouseListener ml : listeners = this._header.getMouseListeners()) {
            String className = ml.getClass().toString();
            if (!className.contains("BasicTableHeaderUI")) continue;
            this._uiListener = ml;
            this._header.removeMouseListener(ml);
            this._header.addMouseListener(this);
        }
        this._tableColumnModel = table.getColumnModel();
        this._columnWidths = new int[this._tableColumnModel.getColumnCount()];
        for (int i = 0; i < this._tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = this._tableColumnModel.getColumn(i);
            this._columnWidths[i] = tableColumn.getPreferredWidth();
        }
    }

    public void addColumnResizeListener(TableColumnsListener tableColumnsListener) {
        this._tableColumnsListeners.add(tableColumnsListener);
    }

    public int[] getWidths() {
        return this._columnWidths;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this._header.getCursor() != RESIZE_CURSOR) {
            this._uiListener.mouseClicked(e);
            return;
        }
        if (e.getClickCount() == 2) {
            Point p = e.getPoint();
            p.x -= 3;
            int column = this._header.columnAtPoint(p);
            this._tableColumnAdjuster.adjustColumn(column);
            TableColumn tableColumn = this._tableColumnModel.getColumn(column);
            if (this._columnWidths[column] != tableColumn.getPreferredWidth()) {
                this._columnWidths[column] = tableColumn.getPreferredWidth();
                this.fireTableColumnWidthChanged();
            }
            this._header.dispatchEvent(new MouseEvent(this._header, 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), 0, false));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._uiListener.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._uiListener.mouseExited(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._uiListener.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TableColumn tableColumn;
        if (this._header.getCursor() != RESIZE_CURSOR) {
            this._uiListener.mouseReleased(e);
            return;
        }
        Point p = e.getPoint();
        p.x -= 3;
        int column = this._header.columnAtPoint(p);
        if (this._columnWidths[column] != (tableColumn = this._tableColumnModel.getColumn(column)).getPreferredWidth()) {
            this._columnWidths[column] = tableColumn.getPreferredWidth();
            this.fireTableColumnWidthChanged();
        }
    }

    private void fireTableColumnWidthChanged() {
        for (TableColumnsListener tableColumnsListener : this._tableColumnsListeners) {
            tableColumnsListener.columnWidthChanged(new EventObject(this));
        }
    }
}

