/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.beacon.JniorInfo;
import com.integ.supporter.JniorItem;
import com.integ.supporter.beacon.BeaconTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class BeaconTableRenderer
implements TableCellRenderer {
    public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int selectedSerialNumber = (Integer)table.getValueAt(row, 0);
        BeaconTableModel model = (BeaconTableModel)table.getModel();
        JniorItem jniorItem = model.getJniorItemBySerialNumber(selectedSerialNumber);
        JniorInfo jniorInfo = jniorItem.getJniorInfo();
        if (null != jniorInfo && !isSelected) {
            try {
                if (null != jniorInfo.LastAnnounced && System.currentTimeMillis() < jniorInfo.LastAnnounced.getTime() + 1000L) {
                    c.setBackground(Color.decode("#c0ffc0"));
                } else if (2 == jniorInfo.Status) {
                    c.setBackground(Color.decode("#ffc0c0"));
                } else if (1 == jniorInfo.Status) {
                    c.setBackground(Color.decode("#ffffc0"));
                } else if (0 != jniorInfo.AttentionInfo) {
                    if (0 != (jniorInfo.AttentionInfo & 0x20)) {
                        c.setBackground(Color.decode("#ffdfbf"));
                    } else {
                        c.setBackground(Color.decode("#ffffe0"));
                    }
                } else if (row % 2 == 0) {
                    c.setBackground(Color.WHITE);
                } else {
                    c.setBackground(Color.decode("#F8F8F8"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (9 == column) {
            c.setFont(new Font("Dialog", 1, 12));
        }
        return c;
    }
}

