/*
 * Decompiled with CFR 0.152.
 */
package com.integ.beacon;

import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private String _versionString;
    private final int _major;
    private final int _minor;
    private final int _revision;
    private final float _build;

    public Version(int major, int minor, int revision, float build) {
        this._major = major;
        this._minor = minor;
        this._revision = revision;
        this._build = build;
    }

    public static Version parse(String versionString) throws Exception {
        try {
            if ('v' == versionString.charAt(0)) {
                versionString = versionString.substring(1);
            }
            String[] buildParts = versionString.split("-");
            StringTokenizer tokenizer = new StringTokenizer(buildParts[0], ".", false);
            int major = Integer.valueOf(tokenizer.nextToken());
            int minor = Integer.valueOf(tokenizer.nextToken());
            int revision = 0;
            if (tokenizer.hasMoreTokens()) {
                revision = Integer.valueOf(tokenizer.nextToken());
            }
            float build = 0.0f;
            if (tokenizer.hasMoreTokens()) {
                build = Integer.valueOf(tokenizer.nextToken()).intValue();
            }
            if (1 < buildParts.length) {
                if (0 == buildParts[1].indexOf("a")) {
                    buildParts[1] = buildParts[1].substring(1);
                } else if (0 == buildParts[1].indexOf("b")) {
                    buildParts[1] = buildParts[1].substring(1);
                } else if (0 == buildParts[1].indexOf("rc")) {
                    buildParts[1] = buildParts[1].substring(2);
                }
                Float.valueOf(buildParts[1]);
            }
            Version version = new Version(major, minor, revision, build);
            version._versionString = versionString;
            return version;
        }
        catch (Exception ex) {
            throw new Exception("Error parsing " + versionString, ex);
        }
    }

    public static Version getVersionFromBuildTag(String buildTag) {
        long buildVersionNum = Long.parseLong(buildTag, 16);
        int major = (int)(buildVersionNum >> 44 & 0xFL);
        int minor = (int)(buildVersionNum >> 40 & 0xFL);
        int update = (int)(buildVersionNum >> 36 & 0xFL);
        int status = (int)(buildVersionNum >> 32 & 0xFL);
        int build = (int)(buildVersionNum >> 16 & 0xFFFFL);
        int compile = (int)(buildVersionNum & 0xFFFFL);
        String buildTagVersionString = String.format("v%d.%d", major, minor);
        if (0 < update) {
            buildTagVersionString = buildTagVersionString + "." + update;
        }
        String statusString = "";
        if (0 == status) {
            statusString = "-a";
        } else if (1 == status) {
            statusString = "-b";
        } else if (2 == status) {
            statusString = "-rc";
        } else if (3 == status) {
            statusString = " build ";
        }
        if (0 != build || 0 != compile) {
            buildTagVersionString = buildTagVersionString + String.format("%s%d.%d", statusString, build, compile);
        }
        Version version = new Version(major, minor, 0, build);
        version._versionString = buildTagVersionString;
        return version;
    }

    public String toString() {
        return this._versionString;
    }

    @Override
    public int compareTo(Version v) {
        if (this._major > v._major) {
            return 1;
        }
        if (this._major < v._major) {
            return -1;
        }
        if (this._minor > v._minor) {
            return 1;
        }
        if (this._minor < v._minor) {
            return -1;
        }
        if (this._revision > v._revision) {
            return 1;
        }
        if (this._revision < v._revision) {
            return -1;
        }
        if (this._build > v._build) {
            return 1;
        }
        if (this._build < v._build) {
            return -1;
        }
        return 0;
    }
}

