/*
 * Decompiled with CFR 0.152.
 */
package com.integ.websocket;

import com.integ.websocket.ConsoleSessionAuthenticationEvent;
import com.integ.websocket.ConsoleSessionAuthenticationListener;
import com.integ.websocket.ConsoleSessionPromptListener;
import com.integ.websocket.WebSocketClient;
import com.integ.websocket.WebSocketClientErrorEvent;
import com.integ.websocket.WebSocketClientEvent;
import com.integ.websocket.WebSocketClientEventListener;
import com.integ.websocket.WebSocketClientMessageListener;
import com.integ.websocket.WebSocketClientMessageReceivedEvent;
import com.integ.websocket.messages.ConsoleClose;
import com.integ.websocket.messages.ConsoleOpen;
import com.integ.websocket.messages.ConsoleStdIn;
import com.integ.websocket.messages.Login;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class ConsoleSession
implements WebSocketClientEventListener,
WebSocketClientMessageListener {
    private final Pattern PROMPT_PATTERN = Pattern.compile("[\\r?\\n]*([\\w-]*) (\\/\\w*)+> $");
    private final WebSocketClient _webSocketClient;
    private final ArrayList<ConsoleSessionAuthenticationListener> _authenticationListeners = new ArrayList();
    private final ArrayList<ConsoleSessionPromptListener> _promptListeners = new ArrayList();
    private boolean _isOpen;
    private boolean _isLoggedIn;
    private final Object _promptLock = new Object();
    private final StringBuilder _response = new StringBuilder();
    private boolean _waitingForPrompt = false;
    private String _hostname = null;
    private Logger _logger = Logger.getGlobal();

    public ConsoleSession(WebSocketClient webSocketClient) {
        this._webSocketClient = webSocketClient;
        this._webSocketClient.addEventListener(this);
        this._webSocketClient.addMessageListener(this);
    }

    public ConsoleSession addAuthenticationListener(ConsoleSessionAuthenticationListener listener) {
        this._authenticationListeners.add(listener);
        return this;
    }

    public ConsoleSession addPromptListener(ConsoleSessionPromptListener listener) {
        this._promptListeners.add(listener);
        return this;
    }

    public String getHostname() {
        return this._hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(WebSocketClientMessageReceivedEvent event) {
        block18: {
            try {
                Matcher matcher;
                JSONObject jsonMessage = event.getJsonMessage();
                if (null == jsonMessage || "".equals(jsonMessage)) {
                    return;
                }
                JSONObject json = jsonMessage;
                String message = json.getString("Message");
                if ("Console Response".equalsIgnoreCase(message)) {
                    String status = json.getString("Status");
                    if ("Established".equalsIgnoreCase(status) || !"Closed".equalsIgnoreCase(status) || null == this._promptLock) break block18;
                    Object object = this._promptLock;
                    synchronized (object) {
                        this._promptLock.notifyAll();
                        break block18;
                    }
                }
                if (!"Console Stdout".equalsIgnoreCase(message)) break block18;
                String data = json.getString("Data");
                if (data.contains(" login: ")) {
                    Login login = this._webSocketClient.getLoginCredentials();
                    this.send(login.getUsername() + "\n");
                    break block18;
                }
                if (data.contains(" password: ")) {
                    Login login = this._webSocketClient.getLoginCredentials();
                    this.send(login.getPassword() + "\n");
                    break block18;
                }
                if (data.contains("login failed")) {
                    for (ConsoleSessionAuthenticationListener authenticationListener : this._authenticationListeners) {
                        ConsoleSessionAuthenticationEvent authenticationFailedEvent = new ConsoleSessionAuthenticationEvent(this);
                        authenticationListener.onAuthenticationFailed(authenticationFailedEvent);
                    }
                    break block18;
                }
                this._response.append(data);
                if (!this._waitingForPrompt) {
                    String spaceRight = data.replace("\n", "\n   ");
                    this._logger.info(spaceRight);
                }
                if (!(matcher = this.PROMPT_PATTERN.matcher(this._response.toString())).find()) break block18;
                this._hostname = matcher.group(1);
                System.out.println("Hostname: " + this._hostname);
                if (!this._isLoggedIn) {
                    this._isLoggedIn = true;
                    for (ConsoleSessionAuthenticationListener authenticationListener : this._authenticationListeners) {
                        ConsoleSessionAuthenticationEvent authenticationSuccessEvent = new ConsoleSessionAuthenticationEvent(this);
                        authenticationListener.onAuthenticationSuccess(authenticationSuccessEvent);
                    }
                }
                if (this._waitingForPrompt) {
                    System.out.println("response: " + this._response);
                    int start = matcher.start();
                    this._response.setLength(start);
                    Object object = this._promptLock;
                    synchronized (object) {
                        this._promptLock.notifyAll();
                    }
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (ConsoleSessionPromptListener promptListener : ConsoleSession.this._promptListeners) {
                            ConsoleSessionAuthenticationEvent promptEvent = new ConsoleSessionAuthenticationEvent(ConsoleSession.this);
                            promptListener.onPrompt(promptEvent);
                        }
                    }
                }).start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        System.out.println("ConsoleSession.Open: " + this._isOpen);
        ConsoleSession consoleSession = this;
        synchronized (consoleSession) {
            if (!this._isOpen) {
                System.out.println("Open Console");
                ConsoleOpen consoleOpen = new ConsoleOpen();
                this._webSocketClient.send(consoleOpen);
                this._isOpen = true;
            }
        }
    }

    public void close() {
        if (this._isOpen) {
            this._webSocketClient.send(new ConsoleClose());
        }
    }

    public void send(String data) {
        if (!this._isOpen) {
            this.open();
        }
        this._webSocketClient.send(new ConsoleStdIn(data));
    }

    public String exec(String command) {
        return this.exec(command, 120000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec(String command, int timeout) {
        command = String.format("%s\n", command);
        Object object = this._promptLock;
        synchronized (object) {
            this._waitingForPrompt = true;
            this._response.setLength(0);
            this.send(command);
            try {
                this._promptLock.wait(timeout + 30000);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("prompt was not found in specified time", ex);
            }
            this._waitingForPrompt = false;
            return this._response.toString();
        }
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    @Override
    public void onOpen(WebSocketClientEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(WebSocketClientEvent event) {
        if (null != this._promptLock) {
            Object object = this._promptLock;
            synchronized (object) {
                this._promptLock.notifyAll();
            }
        }
    }

    @Override
    public void onError(WebSocketClientErrorEvent event) {
    }

    @Override
    public void onMonitorUpdate(WebSocketClientMessageReceivedEvent event) {
    }
}

