/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.supporter.DetailsFileChooser;
import com.integ.supporter.updater.steps.FtpStep;
import com.integ.supporter.updater.steps.ProjectStep;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProjectStepPanel
extends JPanel {
    protected final ProjectStep _projectStep;
    protected final BeanInfo beaninfo;
    protected final PropertyDescriptor[] _properties;
    protected final HashMap<String, PropertyDescriptor> _propertiesByName = new HashMap();

    public ProjectStepPanel(ProjectStep projectStep) throws IntrospectionException {
        this._projectStep = projectStep;
        this.beaninfo = Introspector.getBeanInfo(projectStep.getClass());
        this._properties = this.beaninfo.getPropertyDescriptors();
    }

    public void init() throws Exception {
        this.setLayout(new BoxLayout(this, 1));
        System.out.println("project step = " + this._projectStep.getName());
        for (PropertyDescriptor propertyDescriptor : this._properties) {
            System.out.println("add " + propertyDescriptor.getName());
            this._propertiesByName.put(propertyDescriptor.getName().toLowerCase(), propertyDescriptor);
        }
        JTextField nameField = this.loadTextField("Name");
        JCheckBox checkBox = this.loadCheckbox("CheckedOnLoad");
    }

    protected JTextField loadTextField(String name) throws Exception {
        final PropertyDescriptor propertyDescriptor = this._propertiesByName.get(name.toLowerCase());
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        JLabel nameLabel = new JLabel();
        nameLabel.setText(propertyDescriptor.getDisplayName());
        panel.add(nameLabel);
        Method readMethod = propertyDescriptor.getReadMethod();
        Object value = readMethod.invoke((Object)this._projectStep, new Object[0]);
        if (value instanceof String[]) {
            value = String.join((CharSequence)", ", (String[])value);
        }
        Method writeMethod = propertyDescriptor.getWriteMethod();
        final JTextField valueField = new JTextField();
        valueField.setSize(250, 20);
        valueField.setPreferredSize(valueField.getSize());
        if (null != value) {
            valueField.setText(value.toString());
        }
        valueField.setEditable(null != writeMethod);
        if (null != writeMethod) {
            valueField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.warn();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.warn();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.warn();
                }

                public void warn() {
                    try {
                        Method method = propertyDescriptor.getWriteMethod();
                        if (null != method) {
                            Parameter[] parameters;
                            String value = valueField.getText();
                            for (Parameter parameter : parameters = method.getParameters()) {
                                if (parameter.getType().equals(String[].class)) {
                                    String[] stringArray = value.split(",");
                                    method.invoke((Object)ProjectStepPanel.this._projectStep, new Object[]{stringArray});
                                    continue;
                                }
                                method.invoke((Object)ProjectStepPanel.this._projectStep, value);
                            }
                            Method readMethod = propertyDescriptor.getReadMethod();
                            Object returnObject = readMethod.invoke((Object)ProjectStepPanel.this._projectStep, new Object[0]);
                            System.out.println("returnObject = " + returnObject);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        panel.add(valueField);
        this.add(panel);
        return valueField;
    }

    protected JCheckBox loadCheckbox(String name) throws Exception {
        final PropertyDescriptor propertyDescriptor = this._propertiesByName.get(name.toLowerCase());
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        JLabel nameLabel = new JLabel();
        nameLabel.setText(propertyDescriptor.getDisplayName());
        panel.add(nameLabel);
        Method readMethod = propertyDescriptor.getReadMethod();
        Object value = readMethod.invoke((Object)this._projectStep, new Object[0]);
        Method writeMethod = propertyDescriptor.getWriteMethod();
        JCheckBox checkBox = new JCheckBox();
        checkBox.setEnabled(null != writeMethod);
        if (null != value) {
            checkBox.setSelected((Boolean)value);
        }
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
                    ButtonModel buttonModel = abstractButton.getModel();
                    boolean armed = buttonModel.isArmed();
                    boolean pressed = buttonModel.isPressed();
                    boolean selected = buttonModel.isSelected();
                    System.out.println("Changed: " + armed + "/" + pressed + "/" + selected);
                    Method method = propertyDescriptor.getWriteMethod();
                    method.invoke((Object)ProjectStepPanel.this._projectStep, buttonModel.isSelected());
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Object returnObject = readMethod.invoke((Object)ProjectStepPanel.this._projectStep, new Object[0]);
                    System.out.println("returnObject = " + returnObject);
                }
                catch (Exception ex) {
                    Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
                }
            }
        };
        checkBox.addChangeListener(changeListener);
        panel.add(checkBox);
        this.add(panel);
        return checkBox;
    }

    protected JTextField loadFileSelectionField(String name) throws Exception {
        final PropertyDescriptor propertyDescriptor = this._propertiesByName.get(name.toLowerCase());
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        JLabel nameLabel = new JLabel();
        nameLabel.setText(propertyDescriptor.getDisplayName());
        panel.add(nameLabel);
        Method readMethod = propertyDescriptor.getReadMethod();
        Object value = readMethod.invoke((Object)this._projectStep, new Object[0]);
        if (value instanceof String[]) {
            value = String.join((CharSequence)", ", (String[])value);
        }
        Method writeMethod = propertyDescriptor.getWriteMethod();
        final JTextField valueField = new JTextField();
        valueField.setSize(200, 20);
        valueField.setPreferredSize(valueField.getSize());
        if (null != value) {
            valueField.setText(value.toString());
        }
        valueField.setEditable(null != writeMethod);
        valueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            public void warn() {
                try {
                    Method method = propertyDescriptor.getWriteMethod();
                    method.invoke((Object)ProjectStepPanel.this._projectStep, valueField.getText());
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Object returnObject = readMethod.invoke((Object)ProjectStepPanel.this._projectStep, new Object[0]);
                    System.out.println("returnObject = " + returnObject);
                }
                catch (Exception ex) {
                    Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
                }
            }
        });
        valueField.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File currentFile;
                FtpStep ftpStep = (FtpStep)ProjectStepPanel.this._projectStep;
                DetailsFileChooser fileChooser = new DetailsFileChooser();
                if (null != ftpStep._absoluteFile && (currentFile = new File(ftpStep._absoluteFile)).exists()) {
                    fileChooser.setCurrentDirectory(currentFile);
                }
                if (0 == fileChooser.showOpenDialog(null)) {
                    File selectedFile = fileChooser.getSelectedFile();
                    valueField.setText(selectedFile.getName());
                    ftpStep.setAbsoluteFilePath(selectedFile.getPath());
                    try {
                        byte[] fileContentBytes = FileUtils.readAllBytes(selectedFile.getPath());
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md.update(fileContentBytes);
                        byte[] digest = md.digest();
                        String newMd5String = HexUtils.bytesToHex(digest).toUpperCase();
                        ftpStep.setMd5(newMd5String);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        panel.add(valueField);
        this.add(panel);
        return valueField;
    }
}

