/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.utils.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class JanosUpd {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJanosUpd(File file) {
        byte[] bytes = new byte[4];
        try {
            FileInputStream fis = new FileInputStream(file.getPath());
            try (DataInputStream dis = new DataInputStream(fis);){
                dis.read(bytes);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("error determining if %s is a Janos UPD file", file.getPath()), ex);
        }
        return bytes[0] == 85 && bytes[1] == 80 && bytes[2] == 68 && bytes[3] == 0;
    }

    public static JanosFileInformation getInformation(File file) {
        try {
            if (!JanosUpd.isJanosUpd(file)) {
                throw new RuntimeException("File is not a valid JANOS UPD");
            }
            FileInputStream fis = new FileInputStream(file.getPath());
            DataInputStream dis = new DataInputStream(fis);
            return JanosUpd.getInformation(dis);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("error getting JanosFileInformation for %s", file.getPath()), ex);
        }
    }

    public static JanosFileInformation getInformation(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            return JanosUpd.getInformation(dis);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("error getting JanosFileInformation from byte array %s", HexUtils.bytesToHex(bytes)), ex);
        }
    }

    private static JanosFileInformation getInformation(DataInputStream dis) throws IOException {
        dis.skip(4L);
        JanosFileInformation janosFileInfo = new JanosFileInformation();
        janosFileInfo.Copyright = JanosUpd.readCString(dis);
        janosFileInfo.Version = JanosUpd.readCString(dis);
        janosFileInfo.Notes = JanosUpd.readCString(dis);
        if (janosFileInfo.Notes.startsWith("0x")) {
            janosFileInfo.BuildTag = janosFileInfo.Notes.substring(0, 14);
        }
        return janosFileInfo;
    }

    public static String getVersionFromBuildTag(String buildTag) {
        if (buildTag.contains("0x")) {
            buildTag = buildTag.substring(buildTag.indexOf("0x") + 2);
        }
        long buildVersionNum = Long.valueOf(buildTag, 16);
        long major = buildVersionNum >> 44 & 0xFL;
        long minor = buildVersionNum >> 40 & 0xFL;
        long status = buildVersionNum >> 32 & 0xFFL;
        long build = buildVersionNum >> 16 & 0xFFFFL;
        long compile = buildVersionNum & 0xFFFFL;
        String buildTagVersion = String.format("v%d.%d", major, minor);
        if (0L == status) {
            buildTagVersion = buildTagVersion + "-a";
        } else if (1L == status) {
            buildTagVersion = buildTagVersion + "-b";
        } else if (2L == status) {
            buildTagVersion = buildTagVersion + "-rc";
        } else if (3L == status) {
            buildTagVersion = buildTagVersion + " build ";
        }
        buildTagVersion = buildTagVersion + String.format("%d.%d", build, compile);
        return buildTagVersion;
    }

    private static String readCString(DataInputStream dis) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = dis.read()) != 0) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static class JanosFileInformation {
        public String Copyright;
        public String Version;
        public String BuildTag;
        public String Notes;
    }
}

