/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot.library;

import com.integ.supporter.snapshot.CaseIncensitiveStringComparator;
import com.integ.supporter.snapshot.DateStringComparator;
import com.integ.supporter.snapshot.FileDateComparator;
import com.integ.supporter.snapshot.SnapshotFile;
import com.integ.supporter.snapshot.library.SnapshotLibraryEvent;
import com.integ.supporter.snapshot.library.SnapshotLibraryListener;
import com.integ.supporter.snapshot.library.SnapshotLibraryNotifier;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnapshotLibrary {
    private static final String IP_PATTERN_STRING = "(?<ipaddress>\\d+\\.\\d+\\.\\d+\\.\\d+)";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("ddMMMyy");
    private static final SimpleDateFormat PATTERN_1_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmm");
    private static final SimpleDateFormat PATTERN_3_DATE_FORMAT = new SimpleDateFormat("ddMMMyyyy_HHmmss");
    private static final Pattern SNAPSHOT_PATTERN_1 = Pattern.compile("(?<ipaddress>\\d+\\.\\d+\\.\\d+\\.\\d+)_(?<date>\\d{8}_\\d{4}).zip");
    private static final Pattern SNAPSHOT_PATTERN_3 = Pattern.compile("(?<serial>\\d{9})_(?<hostname>[\\w\\d-]*)@(?<date>\\d{2}\\w{3}\\d{4}_\\d{6}).zip");
    private static final Pattern SNAPSHOT_PATTERN_2 = Pattern.compile("(?<hostname>[\\w\\d-]*)@(?<date>\\d{2}\\w{3}\\d{4}).zip");
    private static final Pattern SNAPSHOT_PATTERN_4 = Pattern.compile("jr(?<serial>\\d{9})@(?<date>\\d{2}\\w{3}\\d{4}).zip");
    private final Hashtable<String, ArrayList<File>> _snapshotsBySerial = new Hashtable();
    private final Hashtable<String, ArrayList<File>> _snapshotsByHostname = new Hashtable();
    private final Hashtable<String, ArrayList<File>> _snapshotsByDate = new Hashtable();
    private final ArrayList<File> _otherSnapshots = new ArrayList();
    private final SnapshotLibraryNotifier _snapshotLibraryNotifier = new SnapshotLibraryNotifier();
    private int _errors = 0;

    public SnapshotLibrary(final String libraryPath) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    SnapshotLibrary.this.loadLibraryFolder(libraryPath);
                    SnapshotLibrary.this._snapshotLibraryNotifier.notifySnapshotLibraryLoaded(new SnapshotLibraryEvent(this));
                    System.out.println("_errors = " + SnapshotLibrary.this._errors);
                }
                catch (Exception ex) {
                    Logger.getLogger(SnapshotLibrary.class.getName()).severe(ex.getMessage());
                }
            }
        }).start();
    }

    public void loadLibraryFolder(String libraryPath) {
        Logger.getGlobal().info("Loading Snapshot Library: " + libraryPath);
        long start = System.currentTimeMillis();
        ArrayList<File> filesList = new ArrayList<File>();
        this.loadLibraryFolder(libraryPath, 0, filesList);
        filesList.sort(new FileDateComparator());
        for (File file : filesList) {
            this.addSnapshotFile(file);
        }
        long elapsedTime = System.currentTimeMillis() - start;
        Logger.getGlobal().info(String.format("Snapshot Library loaded successfully in %.3f seconds", (double)elapsedTime / 1000.0));
    }

    private void loadLibraryFolder(String libraryPath, int levels, ArrayList<File> filesList) {
        try {
            File fileLibraryRoot = new File(libraryPath);
            File[] files = fileLibraryRoot.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    this.loadLibraryFolder(file.getPath(), levels - 1, filesList);
                    continue;
                }
                if (!file.getPath().endsWith(".zip")) continue;
                filesList.add(file);
                System.out.println("filesList.size() = " + filesList.size());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String[] getSerialNumbers() {
        Enumeration<String> enumeration = this._snapshotsBySerial.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        String[] serialNumberStrings = new String[this._snapshotsBySerial.size()];
        Comparator<String> c = Comparator.comparing(String::toString);
        list.sort(c);
        return list.toArray(serialNumberStrings);
    }

    public File[] getFilesForSerialNumber(String serialNumberString) {
        ArrayList<File> filesList = this._snapshotsBySerial.get(serialNumberString);
        filesList.sort(new FileDateComparator());
        File[] files = new File[filesList.size()];
        return filesList.toArray(files);
    }

    public String[] getHostnames() {
        Enumeration<String> enumeration = this._snapshotsByHostname.keys();
        ArrayList<Object> list = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        String[] hostnameStrings = new String[this._snapshotsBySerial.size()];
        list.sort(new CaseIncensitiveStringComparator());
        return list.toArray(hostnameStrings);
    }

    public File[] getFilesForHostname(String hostnameString) {
        ArrayList<File> filesList = this._snapshotsByHostname.get(hostnameString);
        filesList.sort(new FileDateComparator());
        File[] files = new File[filesList.size()];
        return filesList.toArray(files);
    }

    public String[] getDates() {
        Enumeration<String> enumeration = this._snapshotsByDate.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        String[] dateStrings = new String[this._snapshotsByDate.size()];
        list.sort(new DateStringComparator());
        Collections.reverse(list);
        return list.toArray(dateStrings);
    }

    public File[] getFilesForDate(String dateString) {
        ArrayList<File> filesList = this._snapshotsByDate.get(dateString);
        filesList.sort(new FileDateComparator());
        File[] files = new File[filesList.size()];
        return filesList.toArray(files);
    }

    public File[] getOtherSnapshotFiles() {
        this._otherSnapshots.sort(new FileDateComparator());
        File[] files = new File[this._otherSnapshots.size()];
        return this._otherSnapshots.toArray(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSnapshotFile(File file) {
        SnapshotLibrary snapshotLibrary = this;
        synchronized (snapshotLibrary) {
            try {
                SnapshotFile snapshotFile = new SnapshotFile(file);
                if (snapshotFile.isSnapshotFile()) {
                    String serialNumberString;
                    Date date;
                    String dateString;
                    String fileName = snapshotFile.getName();
                    Matcher matcher = SNAPSHOT_PATTERN_1.matcher(fileName);
                    if (matcher.find()) {
                        String ipAddress = matcher.group("ipaddress");
                        dateString = matcher.group("date");
                        date = PATTERN_1_DATE_FORMAT.parse(dateString);
                        this.updateSnapshotsForDate(file, DATE_FORMAT.format(date));
                    }
                    if ((matcher = SNAPSHOT_PATTERN_3.matcher(fileName)).find()) {
                        serialNumberString = matcher.group("serial");
                        this.updateSnapshotsForSerial(file, serialNumberString);
                        String hostnameString = matcher.group("hostname");
                        this.updateSnapshotsForHostname(file, hostnameString);
                        String dateString2 = matcher.group("date");
                        Date date2 = PATTERN_3_DATE_FORMAT.parse(dateString2);
                        this.updateSnapshotsForDate(file, DATE_FORMAT.format(date2));
                    }
                    if ((matcher = SNAPSHOT_PATTERN_4.matcher(fileName)).find()) {
                        serialNumberString = matcher.group("serial");
                        this.updateSnapshotsForSerial(file, serialNumberString);
                        dateString = matcher.group("date");
                        date = PATTERN_3_DATE_FORMAT.parse(dateString);
                        this.updateSnapshotsForDate(file, DATE_FORMAT.format(date));
                    }
                    if ((matcher = SNAPSHOT_PATTERN_2.matcher(fileName)).find()) {
                        String hostnameString = matcher.group("hostname");
                        this.updateSnapshotsForHostname(file, hostnameString);
                        dateString = matcher.group("date");
                        date = DATE_FORMAT.parse(dateString);
                        this.updateSnapshotsForDate(file, DATE_FORMAT.format(date));
                    } else {
                        this._otherSnapshots.add(file);
                    }
                    this._snapshotLibraryNotifier.notifySnapshotFileLoaded(new SnapshotLibraryEvent(this, snapshotFile));
                    Logger.getLogger(SnapshotLibrary.class.getName()).info("snapshot library loaded " + file.getPath());
                } else {
                    System.out.println(snapshotFile.getName() + " was not a snapshot file");
                }
            }
            catch (Exception ex) {
                this._otherSnapshots.add(file);
                Logger.getLogger(SnapshotLibrary.class.getName()).severe("error laoding snapshot file: " + ex.toString());
                ++this._errors;
                System.out.println("_errors = " + this._errors);
            }
        }
    }

    private void updateSnapshotsForSerial(File file, String serialString) {
        if (!this._snapshotsBySerial.containsKey(serialString)) {
            this._snapshotsBySerial.put(serialString, new ArrayList());
        }
        ArrayList<File> snapshotFilesForSerial = this._snapshotsBySerial.get(serialString);
        snapshotFilesForSerial.add(file);
    }

    private void updateSnapshotsForHostname(File file, String hostnameString) {
        if (!this._snapshotsByHostname.containsKey(hostnameString)) {
            this._snapshotsByHostname.put(hostnameString, new ArrayList());
        }
        ArrayList<File> snapshotFilesForHostname = this._snapshotsByHostname.get(hostnameString);
        snapshotFilesForHostname.add(file);
    }

    private void updateSnapshotsForDate(File file, String dateString) {
        if (!this._snapshotsByDate.containsKey(dateString)) {
            this._snapshotsByDate.put(dateString, new ArrayList());
        }
        ArrayList<File> snapshotFilesForDate = this._snapshotsByDate.get(dateString);
        snapshotFilesForDate.add(file);
    }

    public void addEventListener(SnapshotLibraryListener snapshotLibraryListener) {
        this._snapshotLibraryNotifier.addEventListener(snapshotLibraryListener);
    }

    public void removeEventListener(SnapshotLibraryListener snapshotLibraryListener) {
        this._snapshotLibraryNotifier.removeEventListener(snapshotLibraryListener);
    }
}

