/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.janoslib.utils.ExceptionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;

public class TextDialog
extends JFrame {
    private JScrollPane jScrollPane2;
    private JTextPane textPane;

    public TextDialog(Frame parent, boolean modal) {
        this.initComponents();
        this.setSize(1024, 768);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.textPane = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.textPane.setBackground(new Color(51, 51, 51));
        this.textPane.setFont(new Font("Monospaced", 0, 12));
        this.textPane.setForeground(new Color(240, 240, 240));
        this.textPane.setText("This is some simple text");
        this.jScrollPane2.setViewportView(this.textPane);
        this.getContentPane().add((Component)this.jScrollPane2, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(TextDialog.class.getName()).severe(stacktrace);
        }
        catch (InstantiationException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(TextDialog.class.getName()).severe(stacktrace);
        }
        catch (IllegalAccessException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(TextDialog.class.getName()).severe(stacktrace);
        }
        catch (UnsupportedLookAndFeelException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(TextDialog.class.getName()).severe(stacktrace);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextDialog dialog = new TextDialog(new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void setText(String text) {
        this.textPane.setText(text);
    }

    public void appendText(String text) {
        try {
            StyledDocument doc = this.textPane.getStyledDocument();
            doc.insertString(doc.getLength(), text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setCaretPosition(int pos) {
        Document doc;
        if (-1 == pos && (doc = this.textPane.getDocument()) != null) {
            pos = doc.getLength();
        }
        this.textPane.setCaretPosition(pos);
    }

    public void setEditable(boolean editable) {
        this.textPane.setEditable(editable);
    }
}

