/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.dialogs.JniorSelectionDialog;
import com.integ.supporter.dialogs.LoginDialog2;
import com.integ.supporter.helpers.IP4Validator;
import com.integ.supporter.snapshot.JniorSnapshotTab;
import com.integ.supporter.snapshot.SnapshotTab;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SnapshotMenu {
    private final JMenuBar _menuBar;
    private JMenuItem _menuAbortSnapshot;

    public SnapshotMenu(JMenuBar menuBar) {
        this._menuBar = menuBar;
        this.createMenu();
    }

    private void createMenu() {
        JMenu menuSnapshot = new JMenu("Snapshot");
        this._menuBar.add(menuSnapshot);
        menuSnapshot.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                Component component = tabbedPane.getSelectedComponent();
                if (component instanceof SnapshotTab) {
                    JniorSnapshotTab selectedSnapshot = SupporterMain.SNAPSHOT_TAB.getSelectedSnapshotTab();
                    if (null != selectedSnapshot) {
                        boolean snapshotInProgress = selectedSnapshot.inProgress();
                        SnapshotMenu.this._menuAbortSnapshot.setEnabled(snapshotInProgress);
                    }
                } else {
                    SnapshotMenu.this._menuAbortSnapshot.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenuItem menuTakeSnapshot = new JMenuItem("Take Snapshot");
        menuTakeSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JniorInfo[] selectedJniors;
                JniorSelectionDialog dlg = new JniorSelectionDialog(null, true);
                dlg.setVisible(true);
                for (JniorInfo selectedRemoteJniorInfo : selectedJniors = dlg.getSelectedJniors()) {
                    SupporterMain.SNAPSHOT_TAB.startSnapshot(selectedRemoteJniorInfo);
                }
                String manuallyEnteredIPAddress = dlg.getManuallyEneteredIPAddress();
                if (IP4Validator.isValid(manuallyEnteredIPAddress)) {
                    JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(SnapshotMenu.this._menuBar);
                    LoginDialog2 loginDialog = new LoginDialog2((Frame)topFrame, true);
                    loginDialog.setTitle("Snapshot for " + manuallyEnteredIPAddress + " needs credentials");
                    loginDialog.centerParent();
                    loginDialog.setVisible(true);
                    if (loginDialog.getResult() == 1) {
                        JniorInfo jniorInfo = new JniorInfo(0);
                        jniorInfo.IpAddress = manuallyEnteredIPAddress;
                        jniorInfo.UserName = loginDialog.getUsername();
                        jniorInfo.Password = loginDialog.getPassword();
                        SupporterMain.SNAPSHOT_TAB.startSnapshot(jniorInfo);
                    }
                }
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                tabbedPane.setSelectedComponent(SupporterMain.SNAPSHOT_TAB);
            }
        });
        menuSnapshot.add(menuTakeSnapshot);
        this._menuAbortSnapshot = new JMenuItem("Abort Snapshot");
        this._menuAbortSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                Component component = tabbedPane.getSelectedComponent();
                JniorSnapshotTab selectedSnapshot = SupporterMain.SNAPSHOT_TAB.getSelectedSnapshotTab();
                if (component instanceof SnapshotTab && null != selectedSnapshot) {
                    JniorSnapshotTab jniorSnapshotTab = selectedSnapshot;
                    jniorSnapshotTab.abort();
                } else {
                    Logger.getGlobal().severe("Selected tab is not an update tab");
                }
            }
        });
        menuSnapshot.add(this._menuAbortSnapshot);
        JMenuItem removeCompleted = new JMenuItem("Remove Completed");
        removeCompleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SupporterMain.SNAPSHOT_TAB.removeCompleted();
                }
                catch (Exception ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    Logger.getGlobal().severe(stacktrace);
                }
            }
        });
        menuSnapshot.add(removeCompleted);
        JMenuItem openSnapshotFolderMenuItem = new JMenuItem("Open Snapshot Folder");
        openSnapshotFolderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    File directoryToOpen = new File(SupporterMain.SNAPSHOTS_FOLDER);
                    desktop.open(directoryToOpen);
                }
                catch (IOException | IllegalArgumentException ex) {
                    Logger.getLogger(SnapshotMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                }
            }
        });
        menuSnapshot.add(openSnapshotFolderMenuItem);
    }
}

