/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.macro;

import com.integ.supporter.cinema.macro.MacroFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

public class LocalMacroFile
extends MacroFile {
    public LocalMacroFile(File file) {
        this.load(file);
        try {
            this.save();
        }
        catch (IOException ex) {
            Logger.getLogger(LocalMacroFile.class.getName()).severe(ex.getMessage());
        }
    }

    @Override
    public void save() throws IOException {
        File outFile = new File(this._file.getPath() + ".tmp");
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(outFile));
            for (String headerRow : this._headerRows) {
                bufferedWriter.write(headerRow + " \r\n");
            }
        }
        catch (IOException ex) {
            throw new IOException("Error Saving the Macro File to " + outFile.getPath(), ex);
        }
        finally {
            try {
                if (null != bufferedWriter) {
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                throw new IOException("Error closing the Macro File: " + outFile.getPath(), ex);
            }
        }
    }
}

