/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.beacon.Beacon;
import com.integ.beacon.JniorInfo;
import com.integ.beacon.commands.QueryCommand;
import com.integ.beacon.commands.RebootCommand;
import com.integ.beacon.commands.ResetAttentionFlagCommand;
import com.integ.beacon.commands.SetHostnameCommand;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.JniorItem;
import com.integ.supporter.OpenTelnetConsole;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.DoGetNetworkCapture;
import com.integ.supporter.beacon.dialogs.ConfigurationDialog;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class BeaconPopupMenu
extends JPopupMenu {
    private final BeaconTab _beaconTab;
    private final JMenuItem _queryAllMenuItem = new JMenuItem("Query All");
    private final JMenuItem _queryMenuItem = new JMenuItem("Query");
    private final JMenuItem _identifyMenuItem = new JMenuItem("Identify");
    private final JMenuItem _setHostnameMenuItem = new JMenuItem("Set Hostname");
    private final JMenuItem _enableDHCPMenuItem = new JMenuItem("Enable DHCP");
    private final JMenuItem _configurationMenuItem = new JMenuItem("Configuration");
    private final JMenuItem _resetAttentionFlagMenuItem = new JMenuItem("Reset Attention Flag");
    private final JMenuItem _rebootMenuItem = new JMenuItem("Reboot");
    private final JMenuItem _launchDcpMenuItem = new JMenuItem("Launch WebUI...");
    private final JMenuItem _openTelnetMenuItem = new JMenuItem("Open Telnet");
    private final JMenuItem _takeSnapshotMenuItem = new JMenuItem("Take Snapshot...");
    private final JMenuItem _getNetworkCaptureMenuItem = new JMenuItem("Get Network Capture...");
    private final JMenuItem _showJniorsysLogMenuItem = new JMenuItem("Show jniorsys.log");
    private final JMenuItem _showErrorsLogMenuItem = new JMenuItem("Show errors.log");
    private final JMenuItem _removeErrorsLogMenuItem = new JMenuItem("Remove errors.log");
    private final JMenuItem _showDumpLogMenuItem = new JMenuItem("Show dump.log");
    private final JMenuItem _removeDumpLogMenuItem = new JMenuItem("Remove dump.log");

    public BeaconPopupMenu(BeaconTab beaconTab) {
        this.initComponents();
        this._beaconTab = beaconTab;
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(200, 1));
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                System.out.println(String.format("%s popup will become visible", this.getClass().getName()));
                int selectedRowCount = BeaconPopupMenu.this._beaconTab.getSelectedRowCount();
                BeaconPopupMenu.this._identifyMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._setHostnameMenuItem.setEnabled(1 == selectedRowCount);
                BeaconPopupMenu.this._configurationMenuItem.setEnabled(1 == selectedRowCount);
                BeaconPopupMenu.this._rebootMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._openTelnetMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._launchDcpMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._resetAttentionFlagMenuItem.setEnabled(false);
                BeaconPopupMenu.this._showErrorsLogMenuItem.setEnabled(false);
                BeaconPopupMenu.this._removeErrorsLogMenuItem.setEnabled(false);
                BeaconPopupMenu.this._showDumpLogMenuItem.setEnabled(false);
                BeaconPopupMenu.this._removeDumpLogMenuItem.setEnabled(false);
                if (1 == selectedRowCount) {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    if (null != jniorInfo) {
                        BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                    }
                    BeaconPopupMenu.this._enableDHCPMenuItem.setEnabled(1 == selectedRowCount && !jniorInfo.DhcpEnabled);
                    BeaconPopupMenu.this._resetAttentionFlagMenuItem.setEnabled(0 != jniorInfo.AttentionInfo);
                    BeaconPopupMenu.this._showErrorsLogMenuItem.setEnabled(0 != (2 & jniorInfo.AttentionInfo));
                    BeaconPopupMenu.this._removeErrorsLogMenuItem.setEnabled(0 != (2 & jniorInfo.AttentionInfo));
                    BeaconPopupMenu.this._showDumpLogMenuItem.setEnabled(0 != (0x20 & jniorInfo.AttentionInfo));
                    BeaconPopupMenu.this._removeDumpLogMenuItem.setEnabled(0 != (0x20 & jniorInfo.AttentionInfo));
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this._queryAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeaconPopupMenu.this._beaconTab.queryAll();
            }
        });
        this.add(this._queryAllMenuItem);
        this._queryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    Beacon.getInstance().send(InetAddress.getByName(jniorInfo.getPublicHostAddress()), jniorInfo.BeaconPort, new QueryCommand(jniorInfo.getSerialNumber()));
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconPopupMenu.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.add(this._queryMenuItem);
        this.addSeparator();
        this._identifyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<JniorItem> selectedJniors = BeaconPopupMenu.this._beaconTab.getSelectedJniorItems();
                    for (JniorItem jniorItem : selectedJniors) {
                        JniorInfo jniorInfo = jniorItem.getJniorInfo();
                        BeaconPopupMenu.this._beaconTab.identify(jniorInfo);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.add(this._identifyMenuItem);
        this._setHostnameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                String result = JOptionPane.showInputDialog(BeaconPopupMenu.this._beaconTab, "Enter the hostname for " + jniorInfo.getSerialNumber(), jniorInfo.Hostname);
                if (null != result && !result.equals(jniorInfo.Hostname) && BeaconPopupMenu.this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                    Beacon.getInstance().broadcastCommand(new SetHostnameCommand(jniorInfo, result));
                }
            }
        });
        this.add(this._setHostnameMenuItem);
        this._enableDHCPMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                            JniorInfo jniorInfo = jniorItem.getJniorInfo();
                            BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                            if (BeaconPopupMenu.this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                                BeaconPopupMenu.this.setDHCP(jniorInfo, true);
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(BeaconPopupMenu.this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
                        }
                    }
                }.start();
            }
        });
        this.add(this._enableDHCPMenuItem);
        this._configurationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                            JniorInfo jniorInfo = jniorItem.getJniorInfo();
                            BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                            JniorInfo jniorInfoClone = jniorInfo.clone();
                            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(BeaconPopupMenu.this._beaconTab);
                            ConfigurationDialog dlg = new ConfigurationDialog((Frame)topFrame, true);
                            dlg.setJniorInfo(jniorInfoClone);
                            dlg.setLocationRelativeTo(null);
                            dlg.setVisible(true);
                            jniorInfoClone = dlg.getJniorInfo();
                            if (null != jniorInfoClone && !jniorInfoClone.equals(jniorInfo) && BeaconPopupMenu.this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                                BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                                jniorInfoClone.Nonce = jniorInfo.Nonce;
                                Thread.sleep(1000L);
                                BeaconPopupMenu.this._beaconTab.setInfo(jniorInfoClone);
                                BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                                jniorInfoClone.Nonce = jniorInfo.Nonce;
                                Thread.sleep(1000L);
                                BeaconPopupMenu.this._beaconTab.setDhcp(jniorInfoClone);
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(BeaconPopupMenu.this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
                        }
                    }
                }).start();
            }
        });
        this.add(this._configurationMenuItem);
        this._resetAttentionFlagMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                if (BeaconPopupMenu.this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                    Beacon.getInstance().broadcastCommand(new ResetAttentionFlagCommand(jniorInfo));
                }
            }
        });
        this.add(this._resetAttentionFlagMenuItem);
        this._rebootMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<JniorItem> selectedJniors = BeaconPopupMenu.this._beaconTab.getSelectedJniorItems();
                    for (JniorItem jniorItem : selectedJniors) {
                        JniorInfo jniorInfo = jniorItem.getJniorInfo();
                        BeaconPopupMenu.this._beaconTab.getInfo(jniorInfo);
                        int result = JOptionPane.showConfirmDialog(BeaconPopupMenu.this._beaconTab, "Are you sure you want to reboot " + jniorInfo.getSerialNumber(), "Confirm Reboot", 0);
                        if (0 != result || !BeaconPopupMenu.this._beaconTab.getJniorInfoCredentials(jniorInfo)) continue;
                        Beacon.getInstance().broadcastCommand(new RebootCommand(jniorInfo));
                        jniorInfo.Status = 1;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.add(this._rebootMenuItem);
        this.addSeparator();
        this._launchDcpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URI uri = null;
                try {
                    ArrayList<JniorItem> selectedJniors = BeaconPopupMenu.this._beaconTab.getSelectedJniorItems();
                    for (JniorItem jniorItem : selectedJniors) {
                        String url = "http://jnior:jnior@" + jniorItem.getIpAddress();
                        uri = new URI(url);
                        Desktop.getDesktop().browse(uri);
                    }
                }
                catch (IOException ioe) {
                    System.out.println("The system cannot find the " + uri + " file specified");
                }
                catch (URISyntaxException use) {
                    System.out.println("Illegal character in path");
                }
            }
        });
        this.add(this._launchDcpMenuItem);
        this._openTelnetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<JniorItem> selectedJniors = BeaconPopupMenu.this._beaconTab.getSelectedJniorItems();
                    for (JniorItem jniorItem : selectedJniors) {
                        final JniorInfo jniorInfo = jniorItem.getJniorInfo();
                        new Thread(){

                            @Override
                            public void run() {
                                OpenTelnetConsole openTelnetConsole = new OpenTelnetConsole(jniorInfo.IpAddress);
                                openTelnetConsole.execute();
                            }
                        }.start();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
                }
            }
        });
        this.add(this._openTelnetMenuItem);
        this._takeSnapshotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<JniorItem> selectedJniors = BeaconPopupMenu.this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    SupporterMain.SNAPSHOT_TAB.startSnapshot(jniorInfo);
                }
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                tabbedPane.setSelectedComponent(SupporterMain.SNAPSHOT_TAB);
            }
        });
        this.add(this._takeSnapshotMenuItem);
        this._getNetworkCaptureMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                int takeNetworkCaptureChoice = JOptionPane.showConfirmDialog(null, "Are you sure you want to take a Network Capture for " + jniorInfo.Hostname, "Take Netowrk Capture?", 0, 3);
                if (0 == takeNetworkCaptureChoice) {
                    jniorInfo.AttentionInfo = (short)(jniorInfo.AttentionInfo | 0x100);
                    DoGetNetworkCapture doGetNetworkCapture = new DoGetNetworkCapture(jniorInfo);
                    doGetNetworkCapture.execute();
                    JOptionPane.showMessageDialog(null, "This will take a moment or two.  Once it is done the file location should be opened in a File Browser depending on your Operating System");
                }
            }
        });
        this.add(this._getNetworkCaptureMenuItem);
        this.addSeparator();
        this._showJniorsysLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    BeaconPopupMenu.this._beaconTab.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{"jniorsys.log.bak", "jniorsys.log"}, true);
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconTab.class.getName()).severe(String.format("error getting jniorsys.log: %s", ExceptionUtils.getStackTrace(ex)));
                }
            }
        });
        this.add(this._showJniorsysLogMenuItem);
        this._showErrorsLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    BeaconPopupMenu.this._beaconTab.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{"errors.log.bak", "errors.log"}, true);
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconTab.class.getName()).severe(String.format("error getting errors.log: %s", ExceptionUtils.getStackTrace(ex)));
                }
            }
        });
        this.add(this._showErrorsLogMenuItem);
        this._removeErrorsLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    int result = JOptionPane.showConfirmDialog(BeaconPopupMenu.this._beaconTab, "Would you like to remove the errors.log file?", "Remove the errors.log file?", 2, 3);
                    if (0 == result) {
                        boolean fileRemoved = BeaconPopupMenu.this._beaconTab.removeRemoteFiles(jniorInfo, new String[]{"errors.log"});
                        if (!fileRemoved) {
                            JOptionPane.showMessageDialog(BeaconPopupMenu.this._beaconTab, "There was an error trying to remove the errors.log file", "Error removing the errors.log file?", 0);
                        } else {
                            jniorInfo.AttentionInfo = (short)(jniorInfo.AttentionInfo ^ 2);
                            if (0 == jniorInfo.AttentionInfo) {
                                Beacon.getInstance().broadcastCommand(new ResetAttentionFlagCommand(jniorInfo));
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconTab.class.getName()).severe(String.format("error getting errors.log: %s", ExceptionUtils.getStackTrace(ex)));
                }
            }
        });
        this.add(this._removeErrorsLogMenuItem);
        this._showDumpLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    BeaconPopupMenu.this._beaconTab.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{"dump.log.bak", "dump.log"}, false);
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconTab.class.getName()).severe(String.format("error getting dump.log: %s", ExceptionUtils.getStackTrace(ex)));
                }
            }
        });
        this.add(this._showDumpLogMenuItem);
        this._removeDumpLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    int result = JOptionPane.showConfirmDialog(BeaconPopupMenu.this._beaconTab, "Would you like to remove the dump.log file?", "Remove the dump.log file?", 2, 3);
                    if (0 == result) {
                        boolean fileRemoved = BeaconPopupMenu.this._beaconTab.removeRemoteFiles(jniorInfo, new String[]{"dump.log"});
                        if (!fileRemoved) {
                            JOptionPane.showMessageDialog(BeaconPopupMenu.this._beaconTab, "There was an error trying to remove the dump.log file", "Error removing the dump.log file?", 0);
                        } else {
                            jniorInfo.AttentionInfo = (short)(jniorInfo.AttentionInfo ^ 0x20);
                            if (0 == jniorInfo.AttentionInfo) {
                                Beacon.getInstance().broadcastCommand(new ResetAttentionFlagCommand(jniorInfo));
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconTab.class.getName()).severe(String.format("error getting dump.log: %s", ExceptionUtils.getStackTrace(ex)));
                }
            }
        });
        this.add(this._removeDumpLogMenuItem);
    }

    private void setDHCP(JniorInfo jniorInfo, boolean enabled) throws InterruptedException {
        jniorInfo.DhcpEnabled = enabled;
        String ipAddress = jniorInfo.IpAddress;
        this._beaconTab.setDhcp(jniorInfo);
        long timeout = System.currentTimeMillis() + 15000L;
        while (System.currentTimeMillis() < timeout) {
            Thread.sleep(2000L);
            this._beaconTab.getInfo(jniorInfo);
            if (ipAddress.equals(jniorInfo.IpAddress)) continue;
            break;
        }
    }
}

