/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.websocket.ConsoleSession;
import com.integ.websocket.ConsoleSessionAuthenticationEvent;
import com.integ.websocket.ConsoleSessionAuthenticationListener;
import com.integ.websocket.ConsoleSessionEvent;
import com.integ.websocket.ConsoleSessionPromptListener;
import com.integ.websocket.WebSocketClient;
import com.integ.websocket.WebSocketClientAuthenticationEvent;
import com.integ.websocket.WebSocketClientAuthenticationListener;
import com.integ.websocket.WebSocketClientErrorEvent;
import com.integ.websocket.WebSocketClientEvent;
import com.integ.websocket.WebSocketClientEventListener;
import com.integ.websocket.WebSocketClientMessageListener;
import com.integ.websocket.WebSocketClientMessageReceivedEvent;
import com.integ.websocket.helpers.DownloadFile;
import com.integ.websocket.messages.Login;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.json.JSONObject;

public class JniorBackup
implements Runnable {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    public static final String BACKUP_DIRECTORY = SupporterMain.SUPPORTER_DIRECTORY + "Backups/";
    private static final Logger LOGGER = RollingLog.getLogger("BackupService");
    private static final Object AUTHENTICATED_WAIT_OBJECT = new Object();
    private static final Object CONSOLE_AUTHENTICATED_WAIT_OBJECT = new Object();
    private final JniorInfo _jniorInfo;
    private final String _host;
    private WebSocketClient _websocketClient;
    private ConsoleSession _consoleSession;
    private boolean _authenticated;
    private boolean _consoleAuthenticated;
    private int _serialNumber;
    private String _folder = "";
    private boolean _recursive = false;
    private String _storagePath;
    private JSONObject _manifestJson;
    private JSONObject _localFilesJson;
    private boolean _isBusy = true;
    private long _nextBackupTime = Long.MAX_VALUE;
    private ArrayList<JSONObject> _pendingFiles;

    public static void addHandler(Handler handler) {
        LOGGER.addHandler(handler);
    }

    public JniorBackup(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
        this._host = jniorInfo.IpAddress;
    }

    public String getHost() {
        return this._host;
    }

    public long getNextBackupTime() {
        return this._nextBackupTime;
    }

    public void setNextBackupTime(long nextBackupTime) {
        LOGGER.info(String.format("%s setting next backup time to %s", this._host, new Date(nextBackupTime)));
        this._nextBackupTime = nextBackupTime;
    }

    public int getSerialNumber() {
        return this._serialNumber;
    }

    public void setFolder(String folder) {
        this._folder = folder;
    }

    public void setRecursive() {
        this._recursive = true;
    }

    public boolean isBusy() {
        return this._isBusy;
    }

    private void init() {
        this._websocketClient = new WebSocketClient(this._host, 80);
        this._websocketClient.addEventListener(new WebSocketClientEventListener(){

            @Override
            public void onOpen(WebSocketClientEvent event) {
                WebSocketClient client = event.getClient();
                LOGGER.info(String.format("%s connected", client.getIpAddress()));
            }

            @Override
            public void onClose(WebSocketClientEvent event) {
                WebSocketClient client = event.getClient();
                LOGGER.info(String.format("%s closed", client.getIpAddress()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(WebSocketClientErrorEvent event) {
                WebSocketClient client = event.getClient();
                LOGGER.info(String.format("%s error: %s", client.getIpAddress(), event.getError()));
                Exception ex = event.getError();
                Logger.getLogger(JniorBackup.class.getName()).severe(ex.getMessage());
                if (ex instanceof ConnectException) {
                    Object object = AUTHENTICATED_WAIT_OBJECT;
                    synchronized (object) {
                        AUTHENTICATED_WAIT_OBJECT.notifyAll();
                    }
                    object = CONSOLE_AUTHENTICATED_WAIT_OBJECT;
                    synchronized (object) {
                        CONSOLE_AUTHENTICATED_WAIT_OBJECT.notifyAll();
                    }
                }
            }

            @Override
            public void onMonitorUpdate(WebSocketClientMessageReceivedEvent event) {
                JSONObject monitorPacketJson = event.getJsonMessage();
                System.out.println("Websocket monitor packet: " + monitorPacketJson);
            }
        });
        this._websocketClient.addAuthenticationListener(new WebSocketClientAuthenticationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSuccess(WebSocketClientAuthenticationEvent event) {
                WebSocketClient client = event.getClient();
                LOGGER.info(String.format("%s authenticated", client.getIpAddress()));
                Object object = AUTHENTICATED_WAIT_OBJECT;
                synchronized (object) {
                    JniorBackup.this._authenticated = true;
                    AUTHENTICATED_WAIT_OBJECT.notifyAll();
                }
                JniorBackup.this._consoleSession = new ConsoleSession(JniorBackup.this._websocketClient);
                JniorBackup.this._consoleSession.addAuthenticationListener(new ConsoleSessionAuthenticationListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onAuthenticationSuccess(ConsoleSessionAuthenticationEvent event) {
                        System.out.println("Console Session authenticated");
                        Object object = CONSOLE_AUTHENTICATED_WAIT_OBJECT;
                        synchronized (object) {
                            JniorBackup.this._consoleAuthenticated = true;
                            CONSOLE_AUTHENTICATED_WAIT_OBJECT.notifyAll();
                        }
                    }

                    @Override
                    public void onAuthenticationFailed(ConsoleSessionAuthenticationEvent event) {
                        System.out.println("Console Session authentication failed");
                    }
                });
                JniorBackup.this._consoleSession.addPromptListener(new ConsoleSessionPromptListener(){

                    @Override
                    public void onPrompt(ConsoleSessionEvent event) {
                        System.out.println("Console Session prompt received");
                    }
                });
                JniorBackup.this._consoleSession.open();
            }

            @Override
            public void onAuthenticationFailed(WebSocketClientAuthenticationEvent event) {
                WebSocketClient client = event.getClient();
                client.login(new Login(((JniorBackup)JniorBackup.this)._jniorInfo.UserName, ((JniorBackup)JniorBackup.this)._jniorInfo.Password, event.getNonce()));
            }
        });
        this._websocketClient.addMessageListener(new WebSocketClientMessageListener(){

            @Override
            public void onMessage(WebSocketClientMessageReceivedEvent event) {
            }
        });
        this._websocketClient.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = System.currentTimeMillis();
        LOGGER.info(String.format("%s Backup Service Started ---", this._host));
        try {
            this.init();
            this.waitForAuthentication();
            if (!this._websocketClient.isConnected()) {
                LOGGER.severe(String.format("%s unable to connect", this._host));
                return;
            }
            if (!this._authenticated || !this._consoleAuthenticated) {
                LOGGER.severe(String.format("%s unable to authenticate", this._host));
                return;
            }
            JSONObject remoteManifestJson = this.updateAndGetManifestJson();
            LOGGER.info("check remote files");
            JSONObject filesJson = remoteManifestJson.getJSONObject("files");
            this.createPendingFilesArrayList(filesJson);
            this._pendingFiles.sort(new Comparator<JSONObject>(){

                @Override
                public int compare(JSONObject o1, JSONObject o2) {
                    String filePath1 = o1.getString("path");
                    String filePath2 = o2.getString("path");
                    return filePath1.compareTo(filePath2);
                }
            });
            this._serialNumber = (int)remoteManifestJson.getLong("serno");
            this._storagePath = BACKUP_DIRECTORY + this._serialNumber + "_" + this._consoleSession.getHostname() + "/";
            LOGGER.info(String.format("set storage location to %s", this._storagePath));
            File storagePathFile = new File(this._storagePath);
            storagePathFile.setLastModified(System.currentTimeMillis());
            LOGGER.info("check local files");
            File manifestFile = new File(this._storagePath + "/manifest.json");
            if (manifestFile.exists()) {
                String manifestFileContents = null;
                try {
                    manifestFileContents = FileUtils.readAllText(manifestFile.getPath());
                    this._manifestJson = new JSONObject(manifestFileContents);
                }
                catch (Exception ex) {
                    if (null != manifestFileContents) {
                        System.out.println("manifestFileContents: " + manifestFileContents);
                    }
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    LOGGER.severe(stacktrace);
                }
            } else {
                this._manifestJson = new JSONObject();
                this._manifestJson.put("files", new JSONObject());
            }
            this._manifestJson.put("model", remoteManifestJson.getString("model"));
            this._manifestJson.put("serno", this._serialNumber);
            this._manifestJson.put("date", new Date());
            this._localFilesJson = this._manifestJson.getJSONObject("files");
            for (int i = 0; i < this._pendingFiles.size(); ++i) {
                String fileMD5;
                JSONObject localFileJson;
                String localFileMD5;
                JSONObject fileJson = this._pendingFiles.get(i);
                String filePath = fileJson.getString("path");
                if (!this._localFilesJson.has(filePath) || !(localFileMD5 = (localFileJson = this._localFilesJson.getJSONObject(filePath)).getString("md5")).equalsIgnoreCase(fileMD5 = fileJson.getString("md5"))) continue;
                this._pendingFiles.remove(i);
                --i;
            }
            LOGGER.info(this._pendingFiles.size() + " files to process");
            while (0 < this._pendingFiles.size()) {
                JSONObject fileJson = this._pendingFiles.remove(0);
                this.downloadFile(fileJson);
            }
            this._websocketClient.close();
        }
        catch (Exception ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stacktrace);
        }
        finally {
            this._websocketClient.disconnect();
        }
        long elapsed = System.currentTimeMillis() - start;
        double elapsedSeconds = (double)elapsed / 1000.0;
        LOGGER.info(String.format("%s Backup Service took %.2f seconds", this._host, elapsedSeconds));
        this._isBusy = false;
        this._authenticated = false;
        this._consoleAuthenticated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFileAs(String filePath, byte[] fileContentBytes) {
        String stacktrace;
        File file = new File(filePath);
        FileOutputStream outputStream = null;
        try {
            ArrayList<File> parentFiles = new ArrayList<File>();
            File parentFile = file.getParentFile();
            while (!parentFile.exists()) {
                parentFiles.add(0, parentFile);
                parentFile = parentFile.getParentFile();
            }
            while (0 < parentFiles.size()) {
                parentFile = (File)parentFiles.remove(0);
                if (parentFile.exists()) continue;
                System.out.println("create " + parentFile.getPath());
                parentFile.mkdir();
            }
            if (null != fileContentBytes) {
                outputStream = new FileOutputStream(filePath);
                outputStream.write(fileContentBytes);
                outputStream.flush();
            }
        }
        catch (Exception ex) {
            stacktrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stacktrace);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    stacktrace = ExceptionUtils.getStackTrace(ex);
                    LOGGER.severe(stacktrace);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAuthentication() {
        Object object = CONSOLE_AUTHENTICATED_WAIT_OBJECT;
        synchronized (object) {
            if (!this._authenticated || !this._consoleAuthenticated) {
                System.out.println("waiting for console authentication");
                try {
                    CONSOLE_AUTHENTICATED_WAIT_OBJECT.wait(5000L);
                }
                catch (InterruptedException ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    LOGGER.severe(stacktrace);
                }
            }
        }
    }

    private JSONObject updateAndGetManifestJson() {
        long start = System.currentTimeMillis();
        LOGGER.info(this._host + " requesting manifest");
        String options = "-u";
        if (this._recursive) {
            options = options + "s";
        }
        String manifestCommand = String.format("manifest %s %s\n", options, this._folder);
        String response = this._consoleSession.exec(manifestCommand, 300000);
        System.out.println("manifest response: " + response);
        DownloadFile downloadFile = new DownloadFile(this._websocketClient, "/manifest.json");
        byte[] fileContentBytes = downloadFile.getContents();
        String fileContents = new String(fileContentBytes);
        System.out.println("fileContents: " + fileContents);
        long elapsed = System.currentTimeMillis() - start;
        double elapsedSeconds = (double)elapsed / 1000.0;
        LOGGER.info(String.format(this._host + " generaterated manifest file in %.2f seconds", elapsedSeconds));
        return new JSONObject(fileContents);
    }

    private void createPendingFilesArrayList(JSONObject filesJson) {
        ArrayList<JSONObject> pendingFiles = new ArrayList<JSONObject>();
        Iterator<String> keys = filesJson.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!(filesJson.get(key) instanceof JSONObject)) continue;
            JSONObject fileJson = filesJson.getJSONObject(key);
            fileJson.put("path", key);
            pendingFiles.add(fileJson);
        }
        this._pendingFiles = pendingFiles;
    }

    private void downloadFile(JSONObject fileJson) {
        long start = System.currentTimeMillis();
        String filePath = fileJson.getString("path");
        System.out.println(new Date(start) + " - download " + filePath);
        LOGGER.info(String.format("%s download %s...", this._host, filePath));
        try {
            DownloadFile downloadFile = new DownloadFile(this._websocketClient, filePath);
            byte[] fileContentBytes = downloadFile.getContents();
            if (null != fileContentBytes && 0 <= fileContentBytes.length) {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(fileContentBytes);
                byte[] digest = md.digest();
                String newMd5String = HexUtils.bytesToHex(digest).toUpperCase();
                fileJson.put("md5", newMd5String);
                String newFilePath = this._storagePath + filePath;
                this.saveFileAs(newFilePath, fileContentBytes);
                long dateTimestamp = fileJson.getLong("date") * 1000L;
                File file = new File(newFilePath);
                file.setLastModified(dateTimestamp);
                double fileSizeInKb = (double)file.length() / 1024.0;
                long elapsed = System.currentTimeMillis() - start;
                double elapsedSeconds = (double)elapsed / 1000.0;
                LOGGER.info(String.format("%s downloaded %s(%.2f KB) in %.2f seconds.  %d files remaining...", this._host, filePath, fileSizeInKb, elapsedSeconds, this._pendingFiles.size()));
                if (20000L < elapsed) {
                    LOGGER.info(filePath + " TOOK A LONG TIME");
                }
                this._localFilesJson.put(filePath, fileJson);
                this._manifestJson.put("files", this._localFilesJson);
                this.saveFileAs(this._storagePath + "/manifest.json", this._manifestJson.toString(2).getBytes());
            } else {
                LOGGER.info(String.format("%s download %s failed", this._host, filePath));
            }
        }
        catch (Exception ex) {
            LOGGER.severe(this._host + " error downloading " + filePath);
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stacktrace);
        }
    }
}

