/*
 * Decompiled with CFR 0.152.
 */
package jniorsupporterlauncher;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import jniorsupporterlauncher.AppLogger;
import jniorsupporterlauncher.LaunchSupporter;

public class JniorSupporterLauncher2 {
    private static final int EXPECTED_VERSION = 11;
    private static final Logger LOGGER = AppLogger.getLogger(System.getProperty("user.home") + "/Desktop/LaunchSupporter");

    public static void main(String[] args) {
        LOGGER.info("start jnior supporter launcher");
        String vmInfoString = String.format("%s %s %s", System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), System.getProperty("java.version"));
        LOGGER.info(vmInfoString);
        String currentJarFilePath = JniorSupporterLauncher2.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        LOGGER.info("currentJarFilePath = " + currentJarFilePath);
        File currentJarFile = new File(currentJarFilePath);
        String javaVersion = System.getProperty("java.version");
        String[] versionElements = javaVersion.split("\\.");
        int discard = Integer.parseInt(versionElements[0]);
        int jvm_version = discard == 1 ? Integer.parseInt(versionElements[1]) : discard;
        try {
            if (11 > jvm_version) {
                throw new Exception(String.format("JNIOR Supporter Requires JVM version %d or higher", 11));
            }
            LaunchSupporter.execute(currentJarFile.getParentFile());
        }
        catch (Exception ex) {
            Logger.getLogger(LaunchSupporter.class.getName()).log(Level.SEVERE, "error", ex);
            File javaFolder = new File("\\Program Files");
            ArrayList<File> folders = new ArrayList<File>();
            folders.add(javaFolder);
            ArrayList<File> foundFiles = new ArrayList<File>();
            long startTime = System.currentTimeMillis();
            long lastTime = System.currentTimeMillis();
            while (!folders.isEmpty()) {
                File folder = (File)folders.remove(0);
                boolean skip = false;
                if (folder.getName().equalsIgnoreCase("android") || folder.getName().equalsIgnoreCase("arduino ide") || folder.getName().equalsIgnoreCase("dell") || folder.getName().equalsIgnoreCase("dotnet") || folder.getName().equalsIgnoreCase("libreoffice") || folder.getName().equalsIgnoreCase("microsoft office") || folder.getName().equalsIgnoreCase("microsoft visual studio")) {
                    skip = true;
                }
                if (skip) {
                    System.out.println("skip " + folder.getName());
                    continue;
                }
                System.out.println("folder: " + folder);
                File[] files = folder.listFiles();
                if (null != files) {
                    for (File file : files) {
                        if (file.isDirectory()) {
                            folders.add(file);
                            continue;
                        }
                        if (!file.getName().equals("javaw.exe")) continue;
                        foundFiles.add(file);
                        LOGGER.info("jvmFile: " + file.getPath());
                    }
                }
                long now = System.currentTimeMillis();
                long delta = now - lastTime;
                System.out.println("delta = " + delta + " total = " + (now - startTime));
                lastTime = now;
            }
            String jvmCommand = null;
            for (File jvmFile : foundFiles) {
                try {
                    String versionString;
                    String[] versionParts;
                    int majorVersion;
                    System.out.println(jvmFile);
                    LOGGER.info("jvmFile: " + jvmFile.getPath());
                    File parentDirectory = jvmFile.getParentFile();
                    File javaFile = new File(parentDirectory.getPath() + "\\java.exe");
                    String cmd = "\"" + javaFile.getPath() + "\" -version";
                    Scanner s = new Scanner(Runtime.getRuntime().exec(cmd).getErrorStream()).useDelimiter("\\A");
                    String output = s.hasNext() ? s.next() : "";
                    System.out.println("output = " + output);
                    for (String line : output.split("\n")) {
                        LOGGER.info(line.trim());
                    }
                    Pattern p = Pattern.compile("\\\"(.*)\\\"");
                    Matcher m = p.matcher(output);
                    if (!m.find() || 11 > (majorVersion = Integer.parseInt((versionParts = (versionString = m.group(1)).split("\\."))[0]))) continue;
                    System.out.println("version = " + majorVersion);
                    LOGGER.info("version = " + majorVersion);
                    Class<JniorSupporterLauncher2> c = JniorSupporterLauncher2.class;
                    String runningJarFile = new File(c.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
                    File runningFile = new File(runningJarFile);
                    runningJarFile = runningFile.getParent() + File.separator + "JniorSupporter.jar";
                    jvmCommand = "\"" + jvmFile.getPath() + "\" -jar \"" + runningJarFile + "\"";
                    break;
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            if (null != jvmCommand) {
                try {
                    System.out.println("found a JVM: " + jvmCommand);
                    LOGGER.info("found a JVM: " + jvmCommand);
                    Runtime.getRuntime().exec(jvmCommand);
                }
                catch (Exception ex2) {
                    Logger.getLogger(JniorSupporterLauncher2.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            String message = String.format("<html>Unable to launch the JNIOR Supporter<br><br>Current JVM: %s<br><br>Please update your installed Java or select a newer JVM if you have more than one installed.<br><br>Here are a list of <a href=\"https://jnior.com/openjdk-options\">JVM options</a></html>.", vmInfoString, 11);
            JEditorPane jep = new JEditorPane("text/html", message);
            jep.setEditable(false);
            jep.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            jep.setFont(new JLabel().getFont());
            jep.setBackground(new JPanel().getBackground());
            jep.addHyperlinkListener(e -> {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            throw new RuntimeException("Desktop Browser Not Supported");
                        }
                        Desktop.getDesktop().browse(new URI(e.getURL().toString()));
                    }
                    catch (Exception ex1) {
                        throw new RuntimeException("Unable to launch a web broswer and navigate to: " + e.getURL().toString(), ex1);
                    }
                }
            });
            JOptionPane.showMessageDialog(null, jep, "Unable to launch the JNIOR Supporter", 0);
        }
    }
}

