/*
 * Decompiled with CFR 0.152.
 */
package jniorsupporterlauncher;

import java.util.Date;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class AppLogger {
    private static final Hashtable<String, Logger> LOGGER_CACHE = new Hashtable();
    private static final int LIMIT = 262144;
    private static final int LOG_COUNT = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        if ("".equals(name)) {
            return Logger.getGlobal();
        }
        try {
            Hashtable<String, Logger> hashtable = LOGGER_CACHE;
            synchronized (hashtable) {
                if (!LOGGER_CACHE.containsKey(name)) {
                    Logger logger = Logger.getLogger(name);
                    FileHandler fileHandler = new FileHandler(name + ".log", 262144, 4, true);
                    fileHandler.setFormatter(new SimpleFormatter(){
                        private static final String FORMAT_STRING = "%1$tF %1$tT, %2$7s, %3$s %n";

                        @Override
                        public synchronized String format(LogRecord logRecord) {
                            return String.format(FORMAT_STRING, new Date(logRecord.getMillis()), logRecord.getLevel().getLocalizedName(), logRecord.getMessage());
                        }
                    });
                    logger.setUseParentHandlers(false);
                    logger.addHandler(fileHandler);
                    logger.info("-------------------------");
                    LOGGER_CACHE.put(name, logger);
                }
                return LOGGER_CACHE.get(name);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(AppLogger.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("uh oh.  global returned");
            return Logger.getGlobal();
        }
    }
}

