/*
 * Decompiled with CFR 0.152.
 */
package jniorsupporterlauncher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jniorsupporterlauncher.AppLogger;
import jniorsupporterlauncher.ResourceUtils;

public class LaunchSupporter {
    private static final Logger LOGGER = AppLogger.getLogger("LaunchSupporter");

    public static void execute(File workingDirectory) throws Exception {
        try {
            String osName = System.getProperty("os.name");
            LOGGER.info(String.format("os: %s", osName));
            File jniorSupporterApplication = new File(workingDirectory.getPath() + "/JniorSupporter.jar");
            boolean localFileFound = jniorSupporterApplication.exists();
            LOGGER.info(String.format("local file found: %s", Boolean.toString(localFileFound)));
            if (!localFileFound) {
                String tmpdir = System.getProperty("java.io.tmpdir");
                System.out.println("Temp file path: " + tmpdir);
                jniorSupporterApplication = new File(tmpdir + File.separator + "JniorSupporter.jar");
                LOGGER.info(String.format("%s exists: %s", jniorSupporterApplication, String.valueOf(jniorSupporterApplication.exists())));
                if (jniorSupporterApplication.exists()) {
                    jniorSupporterApplication.delete();
                }
                LOGGER.info(String.format("extracting %s", jniorSupporterApplication));
                ResourceUtils.extractResource("/resources/JniorSupporter.jar", jniorSupporterApplication);
                LOGGER.info(String.format("extracted %s", jniorSupporterApplication));
            }
            ArrayList cmdArrayList = new ArrayList();
            Collections.addAll(cmdArrayList, "java", "-jar", jniorSupporterApplication.getPath());
            String javaHome = System.getProperty("java.home");
            LOGGER.info("Working Directory = " + System.getProperty("user.dir"));
            String[] cmdArray = cmdArrayList.toArray(new String[cmdArrayList.size()]);
            String commandString = LaunchSupporter.join(cmdArray, " ");
            LOGGER.info(String.format("%s", commandString));
            ProcessBuilder processBuilder = new ProcessBuilder(cmdArray);
            processBuilder.inheritIO();
            LOGGER.info(String.format("executing %s", jniorSupporterApplication));
            processBuilder.start();
        }
        catch (Exception ex) {
            Logger.getLogger(LaunchSupporter.class.getName()).log(Level.SEVERE, "error executing supporter", ex);
            throw ex;
        }
    }

    public static String join(String[] dataArray, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String s : dataArray) {
            if (0 < sb.length()) {
                sb.append(delimiter);
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

