#pragma once

#include "Monitor.h"
#include "JniorConnection.h"
#include "Constants.h"

#include <vector>
#include <iostream>
using namespace std;



static int NEXT_HANDLE = 0;

static const int SEND_RECV_TIMEOUT = 15000;



#pragma pack(1)
struct CONNECT_PARAMS {
	char* host;
	int port;
};



typedef void (CALLBACK* CALLBACKNOTIFY)(void* args);

#pragma pack(1)
struct SERVER_INFO {
	CONNECT_PARAMS* cp;
	int connectedClients;
	int handle;
	int inputs;
	int outputs;
};


class CJnior
{
public:
	int m_handle;
	bool m_quit;

	CJnior(CONNECT_PARAMS* cp);
	~CJnior(void);

	static DWORD WINAPI AcceptConnections(LPVOID lparam);
	int Disconnect();

	//  Added this 02-22-2017 for the 412 and 414
	void SetInputCount(int inputCount);
	//  Added this 02-22-2017 for the 412 and 414
	int GetInputCount();
	int GetInput(int channel);
	int GetInputs();
	int SetInputs(int channelMask, int stateMask);
	//  Added this 02-22-2017 for the 412 and 414
	void SetOutputCount(int inputCount);
	//  Added this 02-22-2017 for the 412 and 414
	int GetOutputCount();
	int GetOutput(int channel);
	int GetOutputs();
	int SetOutputs(int channelMask, int stateMask);
	int PulseOutputs(int channelMask, int stateMask, int duration);
	int GetInputCounter(int channel);
	long long GetInputUsageMeter(int channel);
	long long GetOutputUsageMeter(int channel);

	CONNECT_PARAMS* m_cp;

	CALLBACKNOTIFY ServerInfoNotify;

	void RemoveConnection(CJniorConnection* jniorConnection);

private:
	// our socket object
	SOCKET m_sckt;

	//CMonitor m_mutex;

	std::vector<CJniorConnection*> connections;

	int m_inputCount = 8;
	int m_inputs;
	int m_lastInputs;
	int m_counters[8];
	long m_inputUsageMeters[8];
	long m_inputHiTransitionTime[8];
	int m_outputCount = 8;
	int m_outputs;
	long long m_outputUsageMeters[8];
	long long m_outputHiTransitionTime[8];
	int m_lastOutputs;

	static DWORD WINAPI CJnior::PulseThread(LPVOID lparam);
	int m_nextPulse;
	int m_lastPulse;
	char* m_pulseQueue;
	int m_outputRevertStateMask;
	int m_outputRevertChannelMask;

	void SendServerInfo();
};
