using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace JniorProtocol
{
    /// <summary>
    /// 10V Analog Module
    /// </summary>
    class TypeFD : Device
    {
        public int input1 = 0;
        public int input2 = 0;
        public int input3 = 0;
        public int input4 = 0;
        public int output1 = 0;
        public int output2 = 0;

        public TypeFD(long address)
            : base(address)
        {
        }

        public override void Parse(BinaryReader br)
        {
            input1 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2);
            input2 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2);
            input3 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2);
            input4 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2);
            output1 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2);
            output2 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2);
        }

        public override byte[] GetBytes()
        {
            byte[] bytes = new byte[4];
            Array.Copy(StreamUtils.ToBigEndian(output1, 2), 0, bytes, 0, 2);
            Array.Copy(StreamUtils.ToBigEndian(output2, 2), 0, bytes, 2, 2);
            return bytes;
        }

        public override String ToString()
        {
            return String.Format("{0:x16}", address) + ": 10V Analog Module, Ins=" +
                input1 + ", " +
                input2 + ", " +
                input3 + ", " +
                input4 + ", Outs=" +
                output1 + ", " +
                output2;
        }
    }
}
