using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace JniorProtocol
{
    /// <summary>
    /// RTD Module
    /// </summary>
    class TypeFC : Device
    {
        public int temp1 = 0;
        public int temp2 = 0;
        public int temp3 = 0;
        public int temp4 = 0;

        public TypeFC(long address)
            : base(address)
        {
        }

        public override void Parse(BinaryReader br)
        {
            temp1 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2) * 10;
            temp2 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2) * 10;
            temp3 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2) * 10;
            temp4 = (int)StreamUtils.FromBigEndian(br.ReadBytes(2), 0, 2) * 10;
        }

        public override String ToString()
        {
            return String.Format("{0:x16}", address) + ": RTD Module, Ins=" +
                temp1 + "C, " +
                temp2 + "C, " +
                temp3 + "C, " +
                temp4 + "C";
        }
    }
}
