using System;
using System.Collections.Generic;
using System.Text;
using JniorDll.Net;
using System.Threading;

namespace IOControl.CSharp
{
    class Program
    {
        private static Jnior m_jnior;

        static void Main(string[] args)
        {
            m_jnior = new Jnior();

            ConnectionProperties cp = new ConnectionProperties("10.0.0.213", 9200, 0, 0);
            m_jnior.Connect(cp);

            LoginProperties lp = new LoginProperties("jnior", "jnior");
            m_jnior.Login(lp);



            // Close output 1
            Console.WriteLine("Close Output 1");
            m_jnior.CloseOutput(1);

            Thread.Sleep(1000);

            // Get outputs
            int outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);



            // close all outputs
            Console.WriteLine("Close All Outputs");
            m_jnior.BlockSetRelays(0xff, 0xff);

            Thread.Sleep(1000);

            // Get outputs
            outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);



            // Open Output 3
            Console.WriteLine("Open Output 3");
            m_jnior.OpenOutput(3);

            Thread.Sleep(1000);

            // Gets outputs
            outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);

            // toggle output 1
            Console.WriteLine("Toggle Output 1");
            m_jnior.ToggleOutput(5);

            Thread.Sleep(1000);

            // Gets outputs            
            outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);

            Console.ReadKey();
        }

        static void PrintOutputs(int outputs)
        {
            // the states for all of the outputs are contained in this 8 bit 
            // value.  each bit represents an output.  b7 is output 8 and b0 
            // is output 1.

            Console.WriteLine("Output Mask: 0x" + outputs);
            // go through each output
            for (int i = 0; i < 8; i++)
            {
                // if b0 == 1 then the output is on
                bool state = (outputs & 1) == 1;
                Console.WriteLine("   Output " + (i + 1) + ": " + (state ? "ON" : "OFF"));

                // here we right shift the mask so the next output state will be 
                // in the b0 position
                outputs >>= 1;
            }
        }
    }
}
