// ConnectionCallback.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

// we must include the JniorDll header file that contains all of the function prototypes
#include "JniorDll.h"
// we must include the JniorDll header file that contains all of the structures
#include "JniorStructures.h"
// we must include the JniorDll header file that contains all of the constants
#include "JniorConstants.h"

// a global variable that will hold the handle assigned to the JNIOR session.
int handle;

HANDLE hConnectionCallbackMutex;
HANDLE hLoginCallbackMutex;
HANDLE hMonitorCallbackMutex;

void DoConnect();
void DoLogin();

void CALLBACK ConnectionCallback(void* args) {
	if(WaitForSingleObject(hConnectionCallbackMutex, 10000)==WAIT_TIMEOUT) {
		return;
	}

	STATUS_CALLBACK_ARGS* statusArgs = (STATUS_CALLBACK_ARGS*)args;
	cout << statusArgs->message << endl;

	// if we are connected then we can login
	if (statusArgs->status == STATUS_CONNECTED) {
		DoLogin();
	}

	ReleaseMutex(hConnectionCallbackMutex);
}

void CALLBACK LoginCallback(void* args) {
	if(WaitForSingleObject(hLoginCallbackMutex, 10000)==WAIT_TIMEOUT) {
		return;
	}

	STATUS_CALLBACK_ARGS* statusArgs = (STATUS_CALLBACK_ARGS*)args;
	cout << statusArgs->message << endl;

	// if we are admin then we can toggle the output
	if (statusArgs->status == STATUS_LOGGED_IN_ADMIN) {
		// toggle output 1.  this call does not block.  we will expect a STATUS_OK for 
		// the result
		cout << endl << "Toggle Output 1..." << endl;
		int result = ToggleOutput(handle, 1);
		if (result != STATUS_OK) {
			cout << "Toggle call failed :(" << endl;
			exit(0);
		}
	}

	ReleaseMutex(hLoginCallbackMutex);
}

void CALLBACK MonitorCallback(void* args) {
	if(WaitForSingleObject(hMonitorCallbackMutex, 10000)==WAIT_TIMEOUT) {
		return;
	}

	MONITOR_CALLBACK_ARGS* monitorArgs = (MONITOR_CALLBACK_ARGS*)args;

	char inputStates[9];
	char outputStates[9];

	inputStates[8] = outputStates[8] = '\0';

	for (int i = 7; i >= 0; i--) {
		inputStates[i] = monitorArgs->monitor->inputs[i].state + '0';
		outputStates[i] = monitorArgs->monitor->outputs[i].state + '0';
	}

	time_t time = (time_t)monitorArgs->monitor->jniorTime / 1000;
	char log[128];
	sprintf(log, "Inputs: %s, Outputs: %s, Time: %s\r\n", inputStates, outputStates, ctime(&time));
	cout << log;

	ReleaseMutex(hMonitorCallbackMutex);
}

int _tmain(int argc, _TCHAR* argv[])
{
	// create the jnior session
	handle = CreateJniorSession(NULL);
	cout << "Session Handle: " << handle << endl;

	DoConnect();

	// wait for user input before exiting.  requires stdlib.h
	cout << endl;
	system("pause"); 

	return 0;
}

void DoConnect() {
	// create the connection callback mutex
	hConnectionCallbackMutex = CreateMutex(NULL, false, LPCWSTR("JNIOR_DLL_CONN_CALLBACK_MUTEX"));

	// add a clalback to receive the status of the connection operation
	AddConnectionCallback(handle, &ConnectionCallback);

	// create our connection parameters
	CONNECT_PARAMS* cp = new CONNECT_PARAMS();
	cp->host = "10.0.0.146";
	cp->port = 9200;
	cp->retryCount = 0;
	cp->retryInterval = 0;

	// connect to the jnior using the handle.  here we are using the asynchronous 
	// call to connect.  this means that our application will return immediatley.  
	// We can set up a callback to be alerted when the connection state changes or 
	// we can poll to see when we are connected.  in this sample we have set up a 
	// callback.
	cout << "\r\nConnecting...\r\n";
	int result = ConnectAsync(handle, cp);
}

void DoLogin() {
	// create the connection callback mutex
	hLoginCallbackMutex = CreateMutex(NULL, false, LPCWSTR("JNIOR_DLL_CONN_LOGIN_MUTEX"));

	// add a callback to receive the status of the connection operation
	AddLoginCallback(handle, &LoginCallback);

	// create the connection callback mutex
	hMonitorCallbackMutex = CreateMutex(NULL, false, LPCWSTR("JNIOR_DLL_CONN_MONITOR_MUTEX"));

	// add a clalback to receive the status of the connection operation
	AddMonitorCallback(handle, &MonitorCallback);

	// create our credentials object.  use the default jnior, jnior login 
	// credential for an admin login.
	CREDENTIALS* creds = new CREDENTIALS();
	creds->username = "jnior";
	creds->password = "jnior";

	// login using our handle obtained earlier.  Again this call is asynchronous and 
	// will return immediately.  Again we have set up a callback to be alerted about 
	// a login status change.
	cout << "\r\nLogging In...\r\n";
	int result = LoginAsync(handle, creds);
}
