using System.IO;
using System.Net;
using System.Net.Sockets;
using System;
using System.Diagnostics;

static class StreamUtils
{
    public static string GetString(byte[] bytes, int offset)
    {
        int size = (int)FromBigEndian(bytes, offset, 2);

        try
        {
            if (size < 0) throw new Exception("String size could not be read");
            if (offset + size > bytes.Length) throw new Exception("String size could not be read");
        }
        catch (IOException ex)
        {
            Console.WriteLine(ex.ToString());
            return "";
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.ToString());
            return null;
        }

        // Translate data bytes to a ASCII string.
        return System.Text.Encoding.ASCII.GetString(bytes, offset + 2, size);
    }

    public static string GetString(NetworkStream stream)
    {
        int size = getSize(stream);
        byte[] bytes = new byte[size + 1];
        int i = 0;

        try
        {
            if (size < 0) throw new Exception("String size could not be read");

            i = stream.Read(bytes, 0, size);
            if ((i < size)) throw new Exception("String could not be read");
        }
        catch (IOException ex)
        {
            Console.WriteLine(ex.ToString());
            return "";
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.ToString());
            return null;
        }

        // Translate data bytes to a ASCII string.
        return System.Text.Encoding.ASCII.GetString(bytes, 0, i);
    }

    public static int getSize(Stream stream)
    {
        byte[] bytes = new byte[3];
        int i = 0;
        int size = 0;

        try
        {
            i = stream.Read(bytes, 0, 2);
            if ((i < 2)) throw new Exception("Size could not be read");

            size = (int)FromBigEndian(bytes, 0, 2);
        }
        catch (IOException ex)
        {
            size = 0;
        }
        catch (Exception ex)
        {
            size = -1;
            Console.WriteLine(ex.ToString());
        }

        return size;
    }

    public static byte[] ToBigEndian(long val, int size)
    {
        byte[] bytes = new byte[size + 1];

        try
        {
            while (size > 0)
            {
                bytes[size - 1] = (byte)(val & 0xff);
                val >>= 8;
                size -= 1;
            }
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.ToString());
        }

        return bytes;
    }

    public static long FromBigEndian(byte[] bytes, int offset, int len)
    {
        Int64 l = 0;

        try
        {
            while (len > 0)
            {
                l <<= 8;
                //l *= 256
                l += bytes[offset];
                offset += 1;
                len -= 1;
            }
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.ToString());
        }

        return l;
    }

    public static byte[] sendString(string s)
    {
        int sLength = s.Length;
        byte[] b = new byte[sLength + 3];

        for (int i = 1; i >= 0; i += -1)
        {
            b[i] = (byte)(sLength & 0xff);
            sLength = sLength >> 8;
        }

        Array.Copy(StrToByteArray(s), 0, b, 2, s.Length);

        return b;
    }

    public static byte[] StrToByteArray(string str)
    {
        System.Text.ASCIIEncoding encoding = new System.Text.ASCIIEncoding();
        return encoding.GetBytes(str);
    }
}
