﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using JniorDll.Net;



namespace SetClock {
    class Program {
        static void Main(string[] args) {

            Console.WriteLine("DLL Version: " + Jnior.GetDllVersion());
            Console.WriteLine(".NET Version: " + Jnior.GetAssemblyVersion());
            Console.WriteLine();

            
            // create a jnior object
            Jnior jnior = new Jnior();


            // connect
            ConnectionProperties cp = new ConnectionProperties("10.0.0.63", 9200, 0, 0);
            Console.WriteLine("Connect to " + cp.Host + ":" + cp.Port);
            jnior.Connect(cp);

            if (jnior.IsConnected()) {
                Console.WriteLine("Connected");


                // login
                jnior.Login(new LoginProperties("jnior", "jnior"));

                if (jnior.IsLoggedIn()) {
                    Console.WriteLine("Logged In");


                    // request the current jnior time
                    DateTime jniorTime = jnior.RequestClock();
                    Console.WriteLine("Current Jnior Time: " + jniorTime);


                    // set the jnior time to the start of the current day
                    jnior.SetClock(DateTime.Now.Date);


                    // request the adjusted jnior time
                    jniorTime = jnior.RequestClock();
                    Console.WriteLine("Start of day Jnior Time: " + jniorTime);


                    // set the jnior time to current pc time
                    jnior.SetClock(DateTime.Now);


                    // request the current jnior time
                    jniorTime = jnior.RequestClock();
                    Console.WriteLine("Current Jnior Time: " + jniorTime);

                } // is logged in

            } // is connected


            Console.Read();
        }
    }
}
