using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Globalization;

namespace JniorProtocol
{
    public partial class Form1 : Form
    {
        private JniorSession session = null;
        private Hashtable tenVoltModules = new Hashtable();

        public Form1()
        {
            InitializeComponent();
        }

        private delegate void PrintInfoHandler(string info);
        private void PrintInfo(string info)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new PrintInfoHandler(PrintInfo), new object[] { info });
            }
            else
            {
                txtInfo.AppendText(DateTime.Now.ToString() + " - " + info + "\r\n");
            }
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            session = new JniorSession();

            PrintInfo("Trying to Connect");
            if (session.Connect(txtIpAddress.Text, Convert.ToInt32(txtPort.Text)))
            {
                btnLogin.Enabled = true;
                PrintInfo("Connected");

                session.OnDeviceUpdate += new JniorSession.DeviceHandler(session_OnDeviceUpdate);
            }
            else
            {
                PrintInfo("Could not connect");
            }
        }

        private void session_OnDeviceUpdate(Device device)
        {
            PrintInfo(device.ToString());
        }

        private void btnLogin_Click(object sender, EventArgs e)
        {
            PrintInfo("Logging in");
            int uid = session.Login("jnior", "jnior");
            PrintInfo("Logged in as " + uid);

            // we must be admin in order to control 
            if (uid >= 128)
            {
                btnToggleOutput1.Enabled = true;
            }

            btnEnumerate.Enabled = true;
            btnReadDevices.Enabled = true;
        }

        private void btnToggleOutput1_Click(object sender, EventArgs e)
        {
            PrintInfo("Toggle Output 1");
            session.ToggleOutput(1);
        }

        private void btnEnumerate_Click(object sender, EventArgs e)
        {
            long[] devices = session.EnumerateExternal();

            if (devices != null)
            {
                string deviceList = string.Empty;
                foreach (long addressAsLong in devices)
                {
                    if (!deviceList.Equals(string.Empty))
                    {
                        deviceList += ", ";
                    }
                    string addressAsHex = String.Format("{0:x16}", addressAsLong);
                    deviceList += addressAsHex;

                    if ((addressAsLong & 0xff) == 0xfd)
                    {
                        tenVoltModules.Add(addressAsHex, addressAsLong);
                    }
                }
                PrintInfo("Connected Devices = " + deviceList);

                button1.Enabled = true;
            }


        }

        private void btnReadDevices_Click(object sender, EventArgs e)
        {
            if (tenVoltModules.Count == 0)
            {
                btnEnumerate_Click(this, new EventArgs());
            }

            long[] tenVoltDeviceAddresses = new long[tenVoltModules.Count];

            ICollection values = tenVoltModules.Values;
            int i = 0;
            foreach (long address in values)
            {
                tenVoltDeviceAddresses[i++] = address;
                Console.WriteLine(String.Format("{0:x16}", address));
            }
            TypeFD[] tenVoltDevices = session.ReadExternalTenVoltModules(tenVoltDeviceAddresses);

            foreach (TypeFD tenVoltModule in tenVoltDevices)
            {
                if (tenVoltModule != null)
                {
                    PrintInfo(tenVoltModule.ToString());
                }
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int value = 0;
            Int32.TryParse(txtOutput.Text, out value);

            ICollection values = tenVoltModules.Values;
            foreach (long address in values)
            {
                session.WriteTenVoltModule((TypeFD)session.GetDeviceById(address), 1, value);
            }
        }

        private void btnClearInputCounter1_Click(object sender, EventArgs e)
        {
            PrintInfo("Clear Input Counter 1");
            session.ClearInputCounter(1);
        }

        bool monitorPacketEnabled = true;
        private void btnMonitorPacketToggle_Click(object sender, EventArgs e)
        {
            if (monitorPacketEnabled)
            {
                btnMonitorPacketToggle.Text = "Monitor Packet Enable";
                PrintInfo("Disable Monitor Packet");
            }
            else
            {
                btnMonitorPacketToggle.Text = "Monitor Packet Disable";
                PrintInfo("Enable Monitor Packet");
            }

            monitorPacketEnabled = !monitorPacketEnabled;

            session.EnableMonitorPacket(monitorPacketEnabled);
        }

        private void btnSubscribeChannel1_Click(object sender, EventArgs e)
        {
            PrintInfo("Subscribe to Input Channel 1");
            long[] devices = new long[] { Int64.Parse("00000000000001FF", NumberStyles.HexNumber) };
            session.SubscribeDevices(devices);
        }

        private void btnSubscribeOutputChannel1_Click(object sender, EventArgs e)
        {
            PrintInfo("Subscribe to Output Channel 1");
            long[] devices = new long[] { Int64.Parse("00000000000101FF", NumberStyles.HexNumber) };
            session.SubscribeDevices(devices);
        }

        private void btnReadInputChannel1_Click(object sender, EventArgs e)
        {
            PrintInfo("Read Input Channel 1");
            long[] devices = new long[] { Int64.Parse("00000000000001FF", NumberStyles.HexNumber) };
            session.ReadDevices(devices);
        }

        private void btnReadOutputChannel1_Click(object sender, EventArgs e)
        {
            PrintInfo("Read Output Channel 1");
            long[] devices = new long[] { Int64.Parse("00000000000101FF", NumberStyles.HexNumber) };
            session.ReadDevices(devices);
        }

    }

}