// SimpleC++.cpp : This is the most basic form of JNIOR DLL usage.
//

#include "stdafx.h"

// we must include the JniorDll header file that contains all of the function prototypes
#include "JniorDll.h"
// we must include the JniorDll header file that contains all of the structures
#include "JniorStructures.h"
// we must include the JniorDll header file that contains all of the constants
#include "JniorConstants.h"

// a global variable that will hold the handle assigned to the JNIOR session.
int handle;

int _tmain(int argc, _TCHAR* argv[])
{
	int result;

	// show the version string
	char* version = new char[32];
	result = GetDllVersion(version);
	cout << "Version: " << version << endl;


	// create the jnior session
	handle = CreateJniorSession(NULL);
	cout << "\r\nSession Handle: " << handle << endl;


	// create our connection parameters
	CONNECT_PARAMS* cp = new CONNECT_PARAMS();
	cp->host = "10.0.0.146";
	cp->port = 9200;
	cp->retryCount = 0;
	cp->retryInterval = 0;

	// connect to the jnior using the handle.  here we are using the synchronous 
	// call to connect.  this means that our application will block until the 
	// connect call returns.  when it returns it will return the status of the 
	// connection.  we hope for STATUS_CONNECTED
	cout << endl << "Connecting..." << endl;
	result = Connect(handle, cp);
	if (result == STATUS_CONNECTED) {
		cout << "Connected :)" << endl;
	} else {
		cout << "Connection call failed :(" << endl;
		exit(0);
	}


	// create our credentials object.  use the default jnior, jnior login 
	// credential for an admin login.
	CREDENTIALS* creds = new CREDENTIALS();
	creds->username = "jnior";
	creds->password = "jnior";

	// login using our handle obtained earlier.  Again this call is synchronous and 
	// will block until a login response is received from the jnior or the call 
	// times out.  we will expect STATUS_LOGGED_IN_ADMIN
	cout << endl << "Logging in..." << endl;
	result = Login(handle, creds);
	if (result == STATUS_LOGGED_IN_ADMIN) {
		cout << "Logged in as Admin :)" << endl;
	} else {
		cout << "Login call failed :(" << endl;
		exit(0);
	}

	// NOT THE JNIOR SESSION IS READY TO USE!!!

	// toggle output 1.  this call does not block.  we will expect a STATUS_OK for 
	// the result
	cout << endl << "Toggle output 1..." << endl;
	result = ToggleOutput(handle, 1);
	if (result != STATUS_OK) {
		cout << "Toggle call failed :(" << endl;
		exit(0);
	}

	// wait for user input before exiting.  requires stdlib.h
	cout << endl;
	system("pause"); 

	return 0;
}

