using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace JniorProtocol
{
    class InternalInput : Device
    {
        public byte state = 0;
        public byte alarmState = 0;
        public int count;
        public byte countAlarm1 = 0;
        public byte countAlarm2 = 0;
        public long usageMeter = 0;
        public int usageAlarm = 0;

        public InternalInput(long address)
            : base(address)
        {
        }

        public override void Parse(BinaryReader br)
        {
            Parse(br, false);
        }

        public override void Parse(BinaryReader br, bool deviceRead)
        {
            state = br.ReadByte();
            alarmState = br.ReadByte();
            count = (short)StreamUtils.FromBigEndian(br.ReadBytes(4), 0, 4); ;
            countAlarm1 = br.ReadByte();
            countAlarm2 = br.ReadByte();
            if (deviceRead)
            {
                usageMeter = (long)StreamUtils.FromBigEndian(br.ReadBytes(8), 0, 8);
                usageAlarm = br.ReadByte();
            }
        }

        public override String ToString()
        {
            return String.Format("{0:x16}", address) + ": " +
                "state=" + state + 
                ", count=" + count;
        }
    }
}
