﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using JniorDll.Net;
using System.Net;

namespace JniorServerSample {
    class Program {
        static void Main(string[] args) {

            Console.WriteLine("JNIOR Server Sample");


            // get and display the dll version
            Console.WriteLine("JNIOR DLL: v" + Jnior.GetDllVersion());


            // create our connection properties object and start the server to 
            //  listen for incoming jnior connections.  Listening to 0.0.0.0 
            //  denotes that all network adapters will monitor for incoming 
            //  connections to the specified port.
            ConnectionProperties cp = new ConnectionProperties(IPAddress.Any.ToString(), 9200, 0, 0);
            Jnior.SetAcceptedConnectionCallback(new jnior_dll_calls.AcceptedConnectionCallback(OnAcceptedConnection));
            Jnior.StartServer(cp);


            // press any key to exit
            Console.Read();
        }



        /// <summary>
        /// Our static Accepted Connection Callback for the Local m_jnior Server.  
        /// In addition to the JNIORs accept connections they can establish one 
        /// connection with one client.  Once that connection is established 
        /// the functionality is the same as if the client established the 
        /// communications.
        /// </summary>
        /// <summary>
        /// Here we are alerted that a m_jnior has successfully connected to us.
        /// </summary>
        /// <param name="handle"></param>
        private static void OnAcceptedConnection(Jnior jnior) {
            Console.WriteLine("JNIOR Connection accepted");


            // try to log in with default user and pass
            Console.WriteLine("Jnior " + jnior.Name + " Logging In...");
            jnior.Login(new LoginProperties("jnior", "jnior"));
            Console.WriteLine("Jnior " + jnior.Name + " Logged in: " + jnior.IsLoggedIn());


            // you can save the Jnior object and use it however you like.  If 
            //  the connection is lost the JNIOR will try to reconnect in a 
            //  period of time.  If it is critical you could try to connect 
            //  back to any JNIORs that have connected to the server in the 
            //  past.
        }
    }
}
