using System;
using System.Collections.Generic;
using System.Text;
using JniorDll.Net;
using System.Threading;

namespace IOControl.CSharp
{
    class Program
    {
        private static Jnior m_jnior;

        static void Main(string[] args)
        {

            Console.WriteLine(".NET Wrapper Version: " + Jnior.GetAssemblyVersion() + ", DLL Version: " + Jnior.GetDllVersion() + "\r\n\r\n");

            // Just a different way to code connecting to the jnior.
            //DeviceSettings ds = new DeviceSettings("10.0.0.198", 9200, "jnior", "jnior");
            //bool connected = ConnectToJnior(ds);
            //Console.WriteLine("Customer Code Connected: " + connected);
            //if (connected)
            //{
            //    m_jnior.Disconnect();
            //}
            // Just a different way to code connecting to the jnior.

            m_jnior = new Jnior();
            Console.WriteLine("\r\n\r\nConnecting...");
            ConnectionProperties cp = new ConnectionProperties("10.0.0.198", 9200, 2, 0);
            if (!m_jnior.Connect(cp))
            {
                Console.WriteLine("Could not connect");
                Console.ReadLine();
                return;
            }

            Console.WriteLine("Logging In...");
            LoginProperties lp = new LoginProperties("jnior", "jnior");
            lp.Encode = true;
            m_jnior.Login(lp);
            if (!m_jnior.IsLoggedIn())
            {
                Console.WriteLine("Could not log in");
                Console.ReadLine();
                return;
            }

            // open all outputs
            Console.WriteLine("Open All Outputs");
            if (m_jnior.BlockSetRelays(0xff, 0) != 0)
            {
                Console.WriteLine("Could not open all outputs");
                return;
            }
            Thread.Sleep(5000);

            // set relay 5 to 
            Console.WriteLine("Set Output 5");
            if (m_jnior.SetOutput(4, 1) != 0)
            {
                Console.WriteLine("Could not set output 5");
                return;
            }
            Thread.Sleep(5000);

            // Close output 1
            Console.WriteLine("Close Output 1");
            if (m_jnior.CloseOutput(1) != 0)
            {
                Console.WriteLine("Could not close output 1");
                return;
            }

            Thread.Sleep(1000);

            // Get outputs
            int outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);



            // close all outputs
            Console.WriteLine("Close All Outputs");
            m_jnior.BlockSetRelays(0xff, 0xff);

            Thread.Sleep(1000);

            // Get outputs
            outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);



            // Open Output 3
            Console.WriteLine("Open Output 3");
            m_jnior.OpenOutput(3);

            Thread.Sleep(1000);

            // Gets outputs
            outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);

            // toggle output 1
            Console.WriteLine("Toggle Output 1");
            m_jnior.ToggleOutput(5);

            Thread.Sleep(1000);

            // Gets outputs            
            outputs = m_jnior.GetOutputs();
            PrintOutputs(outputs);

            Console.ReadKey();
        }

        static void PrintOutputs(int outputs)
        {
            // the states for all of the outputs are contained in this 8 bit 
            // value.  each bit represents an output.  b7 is output 8 and b0 
            // is output 1.

            Console.WriteLine("Output Mask: 0x" + outputs);
            // go through each output
            for (int i = 0; i < 8; i++)
            {
                // if b0 == 1 then the output is on
                bool state = (outputs & 1) == 1;
                Console.WriteLine("   Output " + (i + 1) + ": " + (state ? "ON" : "OFF"));

                // here we right shift the mask so the next output state will be 
                // in the b0 position
                outputs >>= 1;
            }
        }





        private static bool ConnectToJnior(DeviceSettings myRequest)
        {
            ConnectionProperties cp = new ConnectionProperties(myRequest.DeviceIP, myRequest.DevicePort, 2, 0);
            m_jnior = new JniorDll.Net.Jnior();
            m_jnior.Connect(cp);

            System.Threading.Thread.Sleep(1000);

            if (m_jnior.IsConnected())
            {
                //There is connection
                LoginProperties lp = new LoginProperties(myRequest.UserName, myRequest.Password);
                lp.Encode = true;
                m_jnior.Login(lp);

                if (m_jnior.IsLoggedIn())
                {
                    return true;
                }
                else
                    return false;
            }
            else
                return false;
        }

    }

    class DeviceSettings
    {
        public string DeviceIP;
        public int DevicePort;
        public string UserName;
        public string Password;

        public DeviceSettings(string deviceIp, int devicePort, string userName, string password)
        {
            DeviceIP = deviceIp;
            DevicePort = devicePort;
            UserName = userName;
            Password = password;
        }
    }
}
