// RegistryUsage.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "JniorDll.h"
#include "JniorConstants.h"
#include "JniorStructures.h"

#include <iostream>
using namespace std;

#include <windows.h>

int handle = 0;

HANDLE hRegistryCallbackMutex;
HANDLE hRegistryListingCallbackMutex;

void CALLBACK RegistryCallback(void* args)
{
	if(WaitForSingleObject(hRegistryCallbackMutex, 10000)==WAIT_TIMEOUT) {
		return;
	}

	REGISTRY_CALLBACK_ARGS* registryArgs = (REGISTRY_CALLBACK_ARGS*)args;

	cout << registryArgs->count << " registry keys returned" << endl;

	REGISTRY_KEY** regKeys = registryArgs->keys;
	for (int i = 0; i < registryArgs->count; i++) {
		cout << regKeys[i]->key << " = " << regKeys[i]->value << endl;
	}

	ReleaseMutex(hRegistryCallbackMutex);
}

void CALLBACK RegistryListingCallback(void* args)
{
	if(WaitForSingleObject(hRegistryListingCallbackMutex, 10000)==WAIT_TIMEOUT) {
		return;
	}

	REGISTRY_LISTING_CALLBACK_ARGS* registryListingArgs = (REGISTRY_LISTING_CALLBACK_ARGS*)args;

	cout << registryListingArgs->count << " registry keys returned" << endl;

	for (int i = 0; i < registryListingArgs->count; i++) {
		cout << "   " << registryListingArgs->keyNames[i] << endl;
	}

	ReleaseMutex(hRegistryListingCallbackMutex);
}

int _tmain(int argc, _TCHAR* argv[])
{
	// initiate the jnior session
	handle = CreateJniorSession(NULL);

	// connect to the jnior using a synchronis call
	CONNECT_PARAMS* cp = new CONNECT_PARAMS();
	cp->host = "10.0.0.146";
	cp->port = 9200;
	int result = Connect(handle, cp);

	// login using the default credentials using a synchronis call
	CREDENTIALS* creds = new CREDENTIALS();
	creds->username = "jnior";
	creds->password = "jnior";
	Login(handle, creds);

	// create an array of 4 registry keys.
	REGISTRY_KEY** regKeys = new REGISTRY_KEY*[4];
	
	// get the REGISTRY_KEY pointer for the $serialnumber registry key
	regKeys[0] = GetRegistryKeyHandle(handle, "$SerialNumber");
	// get the REGISTRY_KEY pointer for the $model registry key
	regKeys[1] = GetRegistryKeyHandle(handle, "$Model");
	// get the REGISTRY_KEY pointer for the $version registry key
	regKeys[2] = GetRegistryKeyHandle(handle, "$Version");
	// get the REGISTRY_KEY pointer for the $boottime registry key
	regKeys[3] = GetRegistryKeyHandle(handle, "$BootTime");

	// now that we have obtained the registry key handles, lets read the values.  
	// these values will never change while the JNIOR is running. so we will only 
	// read them.
	result = ReadRegistryKeys(handle, regKeys, 4, "");

	for (int i = 0; i < 4; i++) {
		cout << regKeys[i]->key << " = " << regKeys[i]->value << endl;
	}

	hRegistryCallbackMutex = CreateMutex(NULL, false, LPCWSTR("JNIOR_DLL_REGISTRY_CALLBACK_MUTEX"));
	// add a registry callback
	AddRegistryCallback(handle, &RegistryCallback);

	// create an array of 1 registry key.
	regKeys = new REGISTRY_KEY*[1];
	
	// get the REGISTRY_KEY pointer for the $hourmeter registry key
	regKeys[0] = GetRegistryKeyHandle(handle, "IO/Outputs/rout1/$HourMeter");

	// the hour meter will change.  Subscribe to this key.
	result = SubscribeRegistryKeysAsync(handle, regKeys, 1, "");

	// now we will make sure output 1 in on so that the usage meter changes
	CloseOutput(handle, 1);


	// writing to a registry key
	regKeys = new REGISTRY_KEY*[1];
	
	// get the REGISTRY_KEY pointer for the demo registry key
	regKeys[0] = GetRegistryKeyHandle(handle, "demo/test");

	SetRegistryKeyValue(handle, regKeys[0], "Look at me");

	// write the keys
	WriteRegistryKeys(handle, regKeys, 1);



	hRegistryListingCallbackMutex = CreateMutex(NULL, false, LPCWSTR("JNIOR_DLL_REGISTRY_LISTING_CALLBACK_MUTEX"));
	// add a registry listing callback
	AddRegistryListingCallback(handle, &RegistryListingCallback);

	// get a registry node listing for the root node
	ListRegistryAsync(handle, "");

	system("pause");

	return 0;
}

