#define STATUS_COMMAND_TIMEOUT			-2
#define STATUS_FAILED					-1
#define STATUS_OK						0

#define STATUS_REBOOTING				1
#define STATUS_NOT_CONNECTED			2
#define STATUS_DISCONNECTED				3
#define STATUS_CONNECTING				4
#define STATUS_RECONNECTING				5
#define STATUS_CONNECTED				6
#define STATUS_CONNECTION_FAILED		7
#define STATUS_CANCELLED				8
#define STATUS_ACCEPTED_CONNECTION		9
#define STATUS_WAIT_FOR_RECV_THREAD		10
#define STATUS_RECV_THREAD_DONE			11
#define STATUS_QUERY_JNIOR_PORT			18
#define STATUS_QUERY_JNIOR_PORT_SUCCESS	19

#define STATUS_NOT_LOGGED_IN			100
#define STATUS_LOGGED_OUT				101
#define STATUS_LOGGING_IN				102
#define STATUS_LOGGED_IN_GUEST			103
#define STATUS_LOGGED_IN_USER			104
#define STATUS_LOGGED_IN_ADMIN			105
#define STATUS_LOGIN_FAILED				106
#define STATUS_LOGIN_INCORRECT_LEVEL	107

#define STATUS_REQUESTING_MONITOR		200
#define STATUS_REQUESTING_USAGE_METERS	201
#define STATUS_REQUESTING_TIME			202

#define STATUS_DISABLE_MONITOR_PACKETS	205
#define STATUS_ENABLE_MONITOR_PACKETS	206

#define STATUS_CLOSE_OUTPUT				301
#define STATUS_OPEN_OUTPUT				302
#define STATUS_TOGGLE_OUTPUT			303
#define STATUS_PULSE_OUTPUT				306
#define STATUS_BLOCK_PULSE_RELAYS		307
#define STATUS_BLOCK_SET_RELAYS			400






#define MONITOR_PACKET					1
#define EXT_MONITOR_PACKET				2

#define REQUEST_PACKET					5

#define SET_CLOCK_PACKET				7
#define USAGE_METER_PACKET				8

#define COMMAND_PACKET					10

#define READ_REG_KEYS					11
#define READ_REG_KEYS_RESPONSE			12

#define WRITE_REG_KEYS					13
#define WRITE_REG_KEYS_RESPONSE			14

#define SUBSCRIBE_REG_KEYS				15

#define LIST_REG_KEYS					16
#define LIST_REG_KEYS_RESPONSE			17

#define READ_DEVICES					21
#define READ_DEVICE_RESPONSE			22
#define SUBSCRIBE_DEVICES				25

#define GET_EXTERNAL_VALUE				29
#define GET_EXTERNAL_VALUE_RESPONSE		30

#define LOGIN_REQUEST					126
#define LOGIN_ACK						125

#define CUSTOM_COMMAND_RESPONSE			254
#define CUSTOM_COMMAND					255


#define PACKET_RECEIVED_START						1000
#define STATUS_MONITOR_PACKET_RECEIVED				PACKET_RECEIVED_START + MONITOR_PACKET
#define STATUS_EXTERNAL_MONITOR_PACKET_RECEIVED		PACKET_RECEIVED_START + EXT_MONITOR_PACKET
#define STATUS_USAGE_METERS_RECEIVED				PACKET_RECEIVED_START + USAGE_METER_PACKET

#define STATUS_REGISTRY_READING						PACKET_RECEIVED_START + READ_REG_KEYS
#define STATUS_REGISTRY_READ_RECEIVED				PACKET_RECEIVED_START + READ_REG_KEYS_RESPONSE

#define STATUS_REGISTRY_WRITING						PACKET_RECEIVED_START + WRITE_REG_KEYS
#define STATUS_REGISTRY_WRITE_RECEIVED				PACKET_RECEIVED_START + WRITE_REG_KEYS_RESPONSE

#define STATUS_READING_DEVICES						PACKET_RECEIVED_START + READ_DEVICES
#define STATUS_READ_DEVICES_RESPONSE				PACKET_RECEIVED_START + READ_DEVICE_RESPONSE

#define STATUS_LOGIN_REQUEST						PACKET_RECEIVED_START + LOGIN_REQUEST
#define STATUS_LOGIN_ACK							PACKET_RECEIVED_START + LOGIN_ACK


#define SOCKET_NOT_WRITABLE							-1000
#define SOCKET_NOT_READABLE							-1001
#define ACK_FAILED									-1002