using System;
using System.Collections.Generic;
using System.Text;
using JniorDll.Net;

namespace RegistryUsage.CSharp
{
    class Program
    {
        static Jnior m_jnior;
        static object registryCallbackLock = new object();
        static object registryListingCallbackLock = new object();

        private static void RegistryCallback(Jnior jnior, RegistryArgs args)
        {
            lock (registryCallbackLock)
            {
                Console.WriteLine("{0} registry keys returned", args.Count);

                foreach (RegistryKey regKey in args.Keys)
                {
                    Console.WriteLine("   {0} = {1}", regKey.Key, regKey.Value);
                }
            }
        }

        private static void RegistryListingCallback(Jnior jnior, RegistryListingArgs args)
        {
            lock (registryListingCallbackLock)
            {
                Console.WriteLine("{0} registry keys returned", args.Count);

                foreach (string regKey in args.KeyNames)
                {
                    Console.WriteLine("   {0}", regKey);
                }
            }
        }

        static void Main(string[] args)
        {
            m_jnior = new Jnior();

            ConnectionProperties cp = new ConnectionProperties("10.0.0.146", 9200, 0, 0);
            m_jnior.Connect(cp);

            LoginProperties lp = new LoginProperties("jnior", "jnior");
            m_jnior.Login(lp);

            RegistryKey[] regKeys = new RegistryKey[4];

            Registry registry = m_jnior.GetRegistryInstance();
            // get the REGISTRY_KEY pointer for the $serialnumber registry key
            regKeys[0] = registry.GetRegistryKey("$SerialNumber");
            // get the REGISTRY_KEY pointer for the $model registry key
            regKeys[1] = registry.GetRegistryKey("$Model");
            // get the REGISTRY_KEY pointer for the $version registry key
            regKeys[2] = registry.GetRegistryKey("$Version");
            // get the REGISTRY_KEY pointer for the $boottime registry key
            regKeys[3] = registry.GetRegistryKey("$BootTime");

            registry.ReadRegistryKeys(regKeys, "");

            foreach (RegistryKey regKey in regKeys)
            {
                Console.WriteLine("   {0} = {1}", regKey.Key, regKey.Value);
            }

            registry.AddRegistryCallback(new jnior_dll_calls.RegistryCallback(RegistryCallback));

            // get the REGISTRY_KEY pointer for the $hourmeter registry key
            RegistryKey hourMeterRegKey = registry.GetRegistryKey("IO/Outputs/rout1/$HourMeter");

            // the hour meter will change.  Subscribe to this key.
            int result = registry.SubscribeRegistryKeyAsync(hourMeterRegKey, "");


            // writing to a registry key
            RegistryKey demoKey = registry.GetRegistryKey("demo/test");
            demoKey.Value = "Look at me in CSharp";

            // write the keys
            registry.WriteRegistryKey(demoKey);


            // add a registry listing callback
            registry.AddRegistryListingCallback(new jnior_dll_calls.RegistryListingCallback(RegistryListingCallback));

            registry.ListRegistryAsync("");

            Console.ReadKey();
        }
    }
}
