// JniorProtocolSample.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "stdio.h"
#include <WinSock2.h>
#include <Windows.h>
#include <time.h>

#pragma comment (lib, "Ws2_32.lib")


#define DEFAULT_BUFLEN 512



struct INTERNAL_INPUT {
	byte state;
	byte alarm;
	long count;
	byte alarm1;
	byte alarm2;
};



static int Send(SOCKET socket, char* packet, int length) {
	packet[0] = 0x01;
	packet[1] = (length - 5) / 256;
	packet[2] = (length - 5) % 256;
	packet[3] = 0xff;
	packet[4] = 0xff;

		
	fd_set fds;
	FD_ZERO(&fds);
	FD_SET(socket, &fds);

	timeval timeout;
	timeout.tv_sec = 3;
	timeout.tv_usec = 0;


	int isWritable = select(0, NULL, &fds, NULL, &timeout);

	if (isWritable == SOCKET_ERROR || isWritable == 0 ) {
		int error = WSAGetLastError();
		printf("Error: %d\n", error);
		return error;
	}
	else {
		int bytesSent = send(socket, packet, length, 0);

		if (bytesSent == SOCKET_ERROR) {
			int error = WSAGetLastError();
			printf("Error: %d\n", error);
			return error;
		} else printf("Bytes Sent: %ld\n", bytesSent);
	}


	return TRUE;
}



static int SendLogin(SOCKET s, char* username, char* password) {
	int usernameLen = strlen(username);
	int passwordLen = strlen(password);
	int packetLen = usernameLen + 1 + passwordLen + 1 + 6;
	char* packet = new char[packetLen];


	int pos = 5;
	packet[pos++] = 126;
	packet[pos++] = usernameLen;
	strncpy(&packet[pos], username, usernameLen);
	pos += usernameLen;
	packet[pos++] = passwordLen;
	strncpy(&packet[pos++], password, passwordLen);
	pos += passwordLen;


	int result = Send(s, packet, packetLen);


	return result;
}



static int ReadShort(char* buf, int* pos) {
	int s = (buf[(*pos)++] << 8);
	s += buf[(*pos)++];

	return s;
}



static int ReadInt(char* buf, int* pos) {
	int i = (buf[(*pos)++] << 24);
	i += (buf[(*pos)++] << 16);
	i += (buf[(*pos)++] << 8);
	i += buf[(*pos)++];

	return i;
}



static long long ReadLong(char* buf, int* pos) {
	int l = (buf[(*pos)++] << 56);
	l += (buf[(*pos)++] << 48);
	l += (buf[(*pos)++] << 40);
	l += (buf[(*pos)++] << 32);
	l += (buf[(*pos)++] << 24);
	l += (buf[(*pos)++] << 16);
	l += (buf[(*pos)++] << 8);
	l += buf[(*pos)++];

	return l;
}



/**
 * Called when a socket is ready to be monitored for incomming data
 */
static DWORD WINAPI Run ( LPVOID lparam )
{
	int result;


	// get the socket from the parameter
	SOCKET Socket = *((SOCKET*) lparam);


	long t0 = clock();


	printf("send login\n");
	if (SendLogin(Socket, "jnior", "jnior") != TRUE) return FALSE;


	// Receive data until the server closes the connection
	int recvBufLen = DEFAULT_BUFLEN;
	char recvBuf[DEFAULT_BUFLEN];
	int bufIn = 0;

	do {
		printf("\nread %d bytes from %d\n", recvBufLen - bufIn, bufIn);


		// read 5 bytes.  these 5 bytes would be the message header
		int bytesRead = recv(Socket, &recvBuf[bufIn], 5, 0);

		if (bytesRead > 0) {
			printf("Bytes received: %d\n", bytesRead);


			int pos = bufIn;
			int headerByte = recvBuf[pos++];
			int packetLen = ReadShort(recvBuf, &pos);
			int packetCrc = ReadShort(recvBuf, &pos);


			int newBufIn = pos;
			while ((bytesRead += recv(Socket, &recvBuf[newBufIn], packetLen, 0)) < packetLen) {
				newBufIn += bytesRead;
			}


			int packetType = recvBuf[pos++];


			long elapsed = clock() - t0;
			char* timeBuf = new char[16];
			sprintf(timeBuf, "%02d:%02d.%03d", elapsed / 60000, (elapsed / 1000) % 60, elapsed % 1000);
			printf("%s   packet received: length %d, crc %d, type %d\n", timeBuf, packetLen, packetCrc, packetType);
			free(timeBuf);


			switch (packetType) {
			case 1: 
				{
					int versionLen = recvBuf[pos++];
					char* version = new char[versionLen + 1];
					memcpy(version,&recvBuf[pos],versionLen);
					version[versionLen] = '\0';
					pos += versionLen;


					INTERNAL_INPUT inputs[8];
					for (int i = 0; i < 8; i++) {
						memcpy(&inputs[i], &recvBuf[pos], 8);
						pos += 8;
					}


					for (int i = 0; i < 8; i++) {
						pos++;
					}


					long long time = ReadLong(recvBuf, &pos);


					printf("monitor packet received.  version %s\n", version);


					free(version);

					break;
				}

			case 2:
				{
					int inputCount = recvBuf[pos++];
					for (int i = 0; i < inputCount; i++) {
						pos++;
					}

					int outputCount = recvBuf[pos++];
					for (int i = 0; i < outputCount; i++) {
						pos++;
					}


					long long time = ReadLong(recvBuf, &pos);


					printf("external monitor packet received.\n");


					break;
				}

			case 125:
				int loginLevel = recvBuf[pos++];
				printf ("login level: %d\n", loginLevel);
				break;
			}


			for ( ; pos < bytesRead; pos++) {
				printf("   %d\n", recvBuf[pos]);
			}


			if (pos == bytesRead) pos = 0;

		} else {
			if (bytesRead == 0) printf("connection closed gracefully by server\n");
			else printf("recv failed: %d\n", WSAGetLastError());
			break;
		}
	} while (true);


	return TRUE;
}




/**
 * our main entry point
 */
int _tmain(int argc, _TCHAR* argv[])
{
	// Startup Winsock
	printf("initialize winsock\n");
	WSADATA wd;
	int result = WSAStartup( MAKEWORD(2,2), &wd );
	if ( result != NO_ERROR ) {
		printf("Error: %d\n", WSAGetLastError());
		return FALSE;
	}


	printf("instantiate our socket\n");
	SOCKET Socket = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	// if we return INVALID_SOCKET then something went wrong.  call cleanup 
	// and raise the Error callback method
	if ( Socket == INVALID_SOCKET ) {
		WSACleanup();
		return FALSE;
	}


	// everything looks good, continue to connect
	sockaddr_in sck_add;
	sck_add.sin_family = AF_INET;
	sck_add.sin_addr.s_addr = inet_addr("10.0.0.121");
	sck_add.sin_port = htons( 9200 );


	result = connect(Socket, (sockaddr *)&sck_add, sizeof(sockaddr_in));
	if (Socket == INVALID_SOCKET) {
		printf("Unable to connect to server!\n");
		WSACleanup();
		return FALSE;
	}


	DWORD m_dwThreadId;
	HANDLE m_hThread = CreateThread (
		NULL,										// default security attributes 
		0,											// use default stack size  
		(LPTHREAD_START_ROUTINE) Run,				// thread function 
		&Socket,									// argument to thread function 
		0,											// use default creation flags 
		&m_dwThreadId);								// returns the thread identifier



	printf("press any key to exit\n");
	char c = getchar();



	printf("clean up socket\n");
	result = shutdown(Socket, SD_SEND);
	closesocket(Socket);
	WSACleanup();



	return TRUE;
}



