using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace JniorProtocol
{
    class InternalOutput : Device
    {
        public byte state = 0;
        public long usageMeter = 0;
        public int usageAlarm = 0;

        public InternalOutput(long address)
            : base(address)
        {
        }

        public override void Parse(BinaryReader br)
        {
            Parse(br, false);
        }

        public override void Parse(BinaryReader br, bool deviceRead)
        {
            state = br.ReadByte();
            if (deviceRead)
            {
                usageMeter = (long)StreamUtils.FromBigEndian(br.ReadBytes(8), 0, 8);
                usageAlarm = br.ReadByte();
            }
        }

        public override String ToString()
        {
            return String.Format("{0:x16}", address) + ": " +
                "state=" + state;
        }
    }
}
