//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/

package com.integpg.system;

/**
 *
 * @author Bruce Cloutier
 */
public class MessagePump {
    
    private long handle = 0;

    /*
     * System messages are messages in the type range 0x01 through 0x3ff.
     * User messages can be defined in the range 0x400 through 0x7fff.
     * Application messages cna be defined beginning at 0x8000.
     */

    /**
     * SM_SHUTDOWN
     */
    public static final int SM_SHUTDOWN    = 0x01;

    /**
     * SM_PROBE
     */
    public static final int SM_PROBE       = 0x02;

    /**
     * SM_PWRSUPP
     */
    public static final int SM_PWRSUPP     = 0x03;

    /**
     * SM_GCRUN
     */
    public static final int SM_GCRUN       = 0x10;

    /**
     * SM_WATCHDOG
     */
    public static final int SM_WATCHDOG    = 0x11;

    /**
     * SM_REGUPDATE
     */
    public static final int SM_REGUPDATE   = 0x40;

    /**
     * SM_WEBSTARTUP
     */
    public static final int SM_WEBSTARTUP  = 0x60;

    /**
     * SM_WEBSHUTDOWN
     */
    public static final int SM_WEBSHUTDOWN = 0x61;

    /**
     * SM_PROTCMDMSG
     */
    public static final int SM_PROTCMDMSG  = 0x70;

    /**
     * SM_PROTCMDRESP
     */
    public static final int SM_PROTCMDRESP = 0x71;

    /**
     * SM_PIPEOPEN
     */
    public static final int SM_PIPEOPEN    = 0x80;

    /**
     * SM_PIPECLOSE
     */
    public static final int SM_PIPECLOSE   = 0x81;

    /**
     * Opens a message pump and creates a message queue. Once opened the program
     * MUST call a form of getMessage() to process messages in a timely fashion.
     * Any message not to be consumed by the current process MUST be reposted so
     * it can reach the intended recipient. Any process not handling messages in
     * a timely fashion will be considered non-responding by the system and may
     * be terminated.
     *
     * @return true if successful
     */
    public boolean open()
    {}

    /**
     * Closes the message pump and releases the message queue. A process MUST
     * insure that close() is called. If the message pump is not closed and
     * the program terminates the system may consider the entire process to be
     * non-responding and terminate.
     */
    public void close()
    {}

    /**
     * Retrieves the desired message from the message queue. All other messages
     * are ignored. Note that they are reposted as required for proper operation.
     *
     * @param type - the message type
     * @return SystemMsg class representing the desired message
     */
    public SystemMsg getMessage(int type)
    {}

    /**
     * Retrieves messages in the specified range from the message queue. All other messages
     * are ignored. Note that they are reposted as required for proper operation.
     *
     * @param low - low end of message range (inclusive)
     * @param high - high end of message range (inclusive)
     * @return SystemMsg class representing a message passing the filter
     */
    public SystemMsg getMessage(int low, int high)
    {}

    /**
     * Retrieve a system message. This blocks on the message queue and returns
     * the next available message as an instance of SystemMsg. Note that if the
     * caller is not the recipient of the message it MUST be reposted using
     * the postMessage() method for proper operation of the system message
     * pump.
     *
     * @return SystemMsg class representing the next available message.
     */
    public SystemMsg getMessage()
    {}

    /**
     * Sends the supplied SystemMsg
     *
     * @param message SystemMsg calls containing the message to send.
     * @return true if successful
     */
    public boolean postMessage(SystemMsg message)
    {}
    
    @Override
    protected void finalize()
            throws Throwable
    {}

    private static native long openMessagePump();
    private static native void closeMessagePump(long hnd);
    private static native byte[] getSystemMsg(long hnd);
    private static native boolean putSystemMsg(long hnd, byte[] msg);
}

