/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package java.lang;

import java.util.Arrays;


/**
 * A mutable sequence of characters.
 * <p>
 * Implements a modifiable string containing a set of characters. The content of
 * the string may be changed at any time using the methods herein. This provides 
 * the common base for (@code StringBuffer) and (@code StringBuilder) which
 * have many similarities.
 * 
 * @author Bruce Cloutier
 */
abstract class AbstractStringBuilder {
    
    /**
    * character array holds content
    */
    char[] value;
    
    /**
     * the count of characters currently in the array
     */
    int count;
    
    /**
     * Create a character buffer of specified size
     */
    AbstractStringBuilder(int size) {}
    
    /**
     * Returns the length of the current content
     * 
     * @return length of the string
     */
    public int length() {}
    
    /**
     * Returns the current size of the array (capacity)
     * 
     * @return size of the array
     */
    public int capacity() {}
    
    /**
     * Make sure that the character array is large enough to store
     * the specified number of characters. It the array is not 
     * large enough this will expand its capacity.
     * 
     * @param size minimum required capacity
     */
    public void ensureCapacity(int size) {}
    
    /**
     * Local method to check capacity. This won't be synchronized.
     * 
     * @param size minimum required capacity
     */
    private void checkSize(int size) {}
    
    /**
     * Expands the capacity of the array to provide space for the
     * required number of characters.
     * 
     * @param size minimum required capacity
     * @throws OutOfMemoryError if sizes are ridiculous
     */
    void expandCapacity(int size) {}
    
    /**
     * Trims the array to the current content.
     */
    public void trimToSize() {}
    
    /**
     * Sets the length of the string content. This truncates the string if
     * the new length is less than the original. Otherwise it will pad the
     * content as necessary with null characters.
     * 
     * @param len new content length
     * @throws IndexOutOfBoundsException as necessary
     */
    public void setLength(int len) {}
    
    /**
     * Returns the character array as it may be needed somewhere.
     */
    final char[] getValue() {}
    
    /**
     * Returns the (@code char) value at the specified index.
     * 
     * @param index the index of the character
     * @return the (@code char) value at the index
     * @throws IndexOutOfBoundsException as necessary
     */
    public char charAt(int index) {}

    /**
     * Moves characters from the starting index to the ending index-1 from the
     * content character array into the supplied array at the specified starting
     * index.
     * 
     * @param from starting index for data in the content array
     * @param to ending index in the content array
     * @param arr supplied destination character array
     * @param start destination starting point to receive data
     */
    public void getChars(int from, int to, char[] arr, int start)
    {}

    /**
     * The character at the specified index is set to the supplied value.
     * 
     * @param index index in the content array
     * @param ch value to be stored
     */
    public void setCharAt(int index, char ch) {}
    
    /**
     * Append string representation of the object to content.
     * 
     * @param obj object to append
     * @return this
     */
    public AbstractStringBuilder append(Object obj) {}

    /**
     * Appends the provided string.
     * 
     * @param str string appended to content
     * @return this
     */
    public AbstractStringBuilder append(String str) {}

    /**
     * Appends content from the supplied (@code StringBuffer) to content.
     * 
     * @param sbuf (@code StringBuffer) object containing data to append
     * @return this
     */
    public AbstractStringBuilder append(StringBuffer sbuf) {}

    /**
     * Appends content for the supplied (@code AbstractStringBuilder) to content.
     * 
     * @param sbuf (@code AbstractStringBuilder) object containing data to append
     * @return this
     */
    AbstractStringBuilder append(AbstractStringBuilder sbuf) {}
    /**
     * Appends character array data to content.
     * 
     * @param arr character array to be appended
     * @return this
     */
    public AbstractStringBuilder append(char[] arr) {}
    
    /**
     * Append character data from array starting at offset for the defined length.
     * 
     * @param arr character array containing data to append
     * @param ofs starting index of the data
     * @param len length of data to append
     * @return this
     */
    public AbstractStringBuilder append(char arr[], int ofs, int len) {}
    
    /**
     * Appends "true" or "false" boolean value to content.
     * 
     * @param bool boolean whose value is to be appended
     * @return this
     */
    public AbstractStringBuilder append(boolean bool) {}

    /**
     * Appends "null" to content.
     * 
     * @return this
     */
    private AbstractStringBuilder appendNull() {}
    
    /**
     * Appends character to content.
     * 
     * @param ch character value to append
     * @return this
     */
    public AbstractStringBuilder append(char ch) {}
    
    /**
     * Appends the value of (@code int) to content.
     * 
     * @param val (@code int) value whose textual representation is to be appended
     * @return this
     */
    public AbstractStringBuilder append(int val) {}
    
    /**
     * Appends the value of (@code long) to content.
     * 
     * @param val (@code long) value whose textual representation is to be appended
     * @return this
     */
    public AbstractStringBuilder append(long val) {}
    
    /**
     * Appends the value of (@code float) to content.
     * 
     * @param val (@code float) value whose textual representation is to be appended
     * @return this
     */
    public AbstractStringBuilder append(float val) {}
    
    /**
     * Appends the value of (@code double) to content.
     * 
     * @param val (@code double) value whose textual representation is to be appended
     * @return this
     */
    public AbstractStringBuilder append(double val) {}
    
    /**
     * Removes the specified range from the content array.
     * 
     * @param from starting index
     * @param to ending index
     * @return this
     */
    public AbstractStringBuilder delete(int from, int to) {}
    
    /**
     * Removes the character from the content sequence.
     * 
     * @param index index to remove
     * @return this
     */
    public AbstractStringBuilder deleteCharAt(int index) {}

    /**
     * Replaces a section in the content sequence.
     * 
     * @param from staring index
     * @param to ending index
     * @param str string content to use as the replacement
     * @return this
     */
    public AbstractStringBuilder replace(int from, int to, String str) {}
    
    /**
     * Returns the (@code String) representation of the substring from starting index
     * to the end of the content array.
     * 
     * @param from staring index
     * @return (@code String) representation of the character set
     */
    public String substring(int from) {}

    /**
     * Returns the (@code String) representation of the substring from starting index
     * to the ending index-1 from the content array.
     * 
     * @param from staring index
     * @param to ending index
     * @return (@code String) representation of the character set
     */
    public String substring(int from, int to) {}
    
    /**
     * Inserts character sequence of a given length starting at an offset in the supplied
     * character array into content at the specified index.
     * 
     * @param from starting indes in the destination content
     * @param arr character array containing data to insert
     * @param ofs starting offset in the supplied data
     * @param len length of data to insert
     * @return this Object
     */
    public AbstractStringBuilder insert(int from, char[] arr, int ofs, int len)
    {}
    
    /**
     * Insert string representation of the object into the content array at the
     * specified offset.
     * 
     * @param ofs starting offset into content
     * @param obj object whose string representation will be inserted
     * @return this Object
     */
    public AbstractStringBuilder insert(int ofs, Object obj) {}
    
    /**
     * Insert (@code String) into content at the starting offset.
     * 
     * @param ofs starting offset in content
     * @param str string to insert
     * @return this
     */
    public AbstractStringBuilder insert(int ofs, String str) {}
    /**
     * Insert character array into content starting at the defined offset.
     * 
     * @param ofs starting offset of destination
     * @param arr character array to insert
     * @return this
     */
    public AbstractStringBuilder insert(int ofs, char[] arr) {}
    /**
     * Insert representation of (@code boolean) into content at the specified offset.
     * 
     * @param ofs offset into destination
     * @param bool boolean whose value is to be inserted
     * @return this
     */
    public AbstractStringBuilder insert(int ofs, boolean bool) {}

    /**
     * Insert character into content at the defined index.
     * 
     * @param index index in content to be updated
     * @param ch character value to store
     * @return this
     */
    public AbstractStringBuilder insert(int index, char ch) {}

    /**
     * Insert (@code int) representation into content at the specified offset.
     * 
     * @param ofs offset into content
     * @param val (@code int) value to insert
     * @return this
     */
    public AbstractStringBuilder insert(int ofs, int val) {}

    /**
     * Insert (@code long) representation into content at the specified offset.
     * 
     * @param ofs offset into content
     * @param val (@code long) value to insert
     * @return this
     */
    public AbstractStringBuilder insert(int ofs, long val) {}

    /**
     * Insert (@code float) representation into content at the specified offset.
     * 
     * @param ofs offset into content
     * @param val (@code float) value to insert
     * @return this
     */
    public AbstractStringBuilder insert(int ofs, float val) {}

    /**
     * Insert (@code double) representation into content at the specified offset.
     * 
     * @param ofs offset into content
     * @param val (@code double) value to insert
     * @return this
     */
    public AbstractStringBuilder insert(int ofs, double val) {}

    /**
     * Returns the index of the specified (@code String) if found or (@code -1) otherwise.
     * 
     * @param str search string
     * @return index if found or (@code -1)
     */
    public int indexOf(String str) {}
    
    /**
     * Returns the index of the specified (@code String) if found or (@code -1) otherwise.
     * 
     * @param str search string
     * @param ofs starting offset for search
     * @return index if found of (@code -1)
     */
    public int indexOf(String str, int ofs) {}
    
    /**
     * returns the index of the last occurrence of the string.
     * 
     * @param str (@code String) to search for
     * @return last index if found or (@code -1)
     */
    public int lastIndexOf(String str) {}
    
    public int lastIndexOf(String str, int fromIndex) {}
    
    /**
      * Return a string representation.
      */
    public abstract String toString();
}
