//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 28-Feb-2013
 * -------------------------------------------------------------------------*/

package com.integpg.system;

/** <PRE>
 * MailComposer.java
 * 
 * Created on February 28, 2013
 * 
 * This class can be used to compose e-mails in a manner very similar to how it
 *  is done on the PC. The composer is constructed and the user may define the 
 *  addressing, content and even attachments in any order finally issuing (or
 *  canceling) the email with a Send(). MIME Version 1.0 is used in transmitting
 *  multi-part/mixed e-mail to included any number of file attachments. Attachments
 *  may be either text or binary.
 * 
 * The minimum requirement is that the user set the "To:" addressing.
 *  The latter is also the "Reply To:" address and should be
 *  a valid address within the domain of the Mail Host. Note that JNIOR cannot
 *  retrieve e-mail and therefore cannot process replies directly.
 * 
 * The following example shows the minimum usage (no message content relying on
 *  the subject line to convey the message):
 * 
 *      MailComposer compose = new MailComposer();
 *      compose.setToAddress( "bcloutier@integpg.com" );
 *      compose.Send();
 * 
 * The following methods optionally augment the message and can be called 
 *  prior to Send().   
 * 
 *      compose.setSubject( "message from JNIOR" );
 *      compose.setCcAddress( "rshulkosky@integpg.com" );
 *      compose.setBccAddress( "rshulkosky@integpg.com" );
 *      compose.setMessage( "The jniorboot.log file has been attached." );
 *      compose.setAttachment( "/jniorsys.log" );
 * 
 * The "To", "CC" and "BCC" addressing may contain multiple e-mail addresses
 *  separated by commas. A message may contain any number of attachments with
 *  each attachment being appended by repeated setAttachment() calls (i.e. each
 *  call appends an attachment - it doesn't replace a prior one).
 * 
 * Note that setMessage() will take either a String or a byte[] object.
 * </PRE>
 */
public class MailComposer {

    private int handle = 0;

    /**
     * Creates new MailComposer
     */
    public MailComposer() {}

    private static native int mailer_create();

    /**
     * This transmits the composed e-mail. If there are any attachments then
     *  the message will be sent using multipart/mixed MIME version 1.0.
     * @return Returns true upon success and false otherwise.
     */
    public boolean send() {}

    private static native boolean mailer_send(int handle);

    /** Resets the composer ready to define a new message. The composer is 
     *  automatically reset at the completion of a Send().
     */
    public void reset() {}

    /**
     * Defines the destination addressing for this message.
     *
     * @param to Defines the 'To:' addressing for the current message.
     */
    public void setToAddress(String to) {}

    /**
     * Defines the destination addressing for this message.
     *
     * @param to Defines the 'To:' addressing for the current message. May
     * specify multiple addresses.
     */
    public void setToAddress(String[] to) {}

    private static native void mailer_addto(int handle, byte[] to);

    /**
     * Defines the "CC" addressing for this message if any.
     *
     * @param cc Defines the 'cc:' addressing to be applied to the current message. This may 
     * contain multiple addresses. This addressing is optional.
     */
    public void setCcAddress(String[] cc) {}

    private static native void mailer_addcc(int handle, byte[] cc);

    /** Defines the "Blind Copy" addressing for this message if any.
     * 
     * @param bcc Defines the 'bcc:' addressing to be applied to the current message.
     * This may contain multiple addresses. This addressing is optional.
     */
    public void setBccAddress(String[] bcc) {}

    private static native void mailer_addbcc(int handle, byte[] bcc);

    /** Defines the Subject for this message. A non-blank subject line is required.
     *
     * @param subject Provides the subject line for the current message.
     */
    public void setSubject(String subject) {}

    private static native void mailer_setsubject(int handle, byte[] subject);

    /** This defines the content for this message. Content is not a requirement
     *  as the point of the message may be conveyed in the subject line. This
     *  may be called multiple times to incrementally build the message body.
     *
     * @param message Conveys the message content which is assumed to be
     * straight text. This content is optional.
     */
    public void setMessage(String message) {}

    private static native void mailer_append(int handle, byte[] message, boolean html);

    /** This defines the content for this message. Content is not a requirement
     *  as the point of the message may be conveyed in the subject line.
     *
     * @param bufr Conveys the message content which is assumed to be
     * straight text. This content is optional.
     */
    public void setMessage(byte[] bufr) {}

    /** This defines the content for this message. Content is not a requirement
     *  as the point of the message may be conveyed in the subject line.
     *
     * @param filespec Indicates the file that conveys the message content which
     * is assumed to be straight text. This content is optional and appended to
     * defined textual message content.
     */
    public void setMessageFile(String filespec) {}

    private static native void mailer_setmsgfile(int handle, byte[] name);

    /** This defines the content for this message. Content is not a requirement
     *  as the point of the message may be conveyed in the subject line. Here
     *  the content is assumed to contain valid HTML.
     *
     * @param message Conveys the message content which is assumed to be HTML.
     * This content is optional.
     */
    public void setMessageHTML(String message) {}

    /** This defines the content for this message. Content is not a requirement
     *  as the point of the message may be conveyed in the subject line. Here
     *  the content is assumed to contain valid HTML.
     *
     * @param bufr Conveys the message content which is assumed to be HTML.
     * This content is optional.
     */
    public void setMessageHTML(byte[] bufr) {}

    /** This adds a file to the attachment list. The file has to be available
     *  for reading at this point. Once a file has been attached the message
     *  will have to be sent in multipart/mixed MIME version 1.0.
     *
     * @param filespec Specifies the file to be attached. One file is attached to
     * the current message for each call to setAttachment(). Multiple files may
     * be associated with a single message.
     *
     */
    public void setAttachment(String filespec) {}

    private static native void mailer_setattach(int handle, byte[] filespec);

    /** This adds a file to the attachment list. The file has to be available
     *  for reading at this point. Once a file has been attached the message
     *  will have to be sent in multipart/mixed MIME version 1.0. This specifies
     *  the Content-Type and encoding. By default all attachments are encoded
     *  with base64 encoding however you may set encode false here and force
     *  the attachment to be sent in human readable form (ascii text).
     *
     * @param filespec Specifies the file to be attached. One file is attached to
     * the current message for each call to setAttachment(). Multiple files may
     * be associated with a single message.
     *
     * @param ctype Specifies the MIME <I>Content-Type</I> to be used with this
     * attachment.
     *
     * @param encode When <B>true</B> (default) the associated attachment will be
     * encoded using base64 encoding. This is most reliable and required for
     * binary attachments. This may be set to <B>false</B> to attach the file
     * as straight text.
     *
     */
    public void setAttachment(String filespec, String ctype, boolean encode) {}

    /**
     * We need to release the handle if the message has not been sent
     * @throws java.lang.Throwable ?
     */
    @Override
    protected void finalize()
            throws java.lang.Throwable
    {}

    private static native void mailer_close(int handle);
}
