//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/

/**
 * This provides Watchdog functionality for use in developing fault tolerant 
 *  applications.
 * 
 * A Watchdog object may be instantiated and opened. 
 * 
 * A Watchdog object represents a countdown timer which may be initialized
 *  with a specific duration. By default an object is created with a 60 
 *  second timer (configured in milliseconds).
 * 
 * The action taken when a Watchdog timer expires may be configured. By 
 *  default a system assertion will be used.
 * 
 * When a Watchdog object is activated is starts to count down from the 
 *  timer setting (60 seconds by default).
 * 
 * During normal operation the Watchdog object must be refreshed before
 *  the timer expires. When the timer is refreshed it restarts from its
 *  configured duration (60 seconds by default).
 * 
 * A Watchdog timer object may be deactivated at any time before expiry.
 */

package com.integpg.system;

/**
 *
 * @author Bruce
 */
public class Watchdog {
    
    // non-zero handle used to access an open watchdog.

    /**
     * handle
     */
        protected int handle = -1;
    
    // action assignments

    /**
     * WDT_REBOOT
     * This is the default action. Expiration of the watchdog timer causes the unit to reboot.
     */
        public static final int WDT_REBOOT = 0;

    /**
     * WDT_APPLICATION
     * This action indicates that a watchdog timer expiration is to be handled by the application 
     * itself. The system takes no action.
     * 
     */
    public static final int WDT_APPLICATION = 1;

    /**
     * WDT_TERMINATE
     * When the watchdog timer expires the system will terminate the application.
     */
    public static final int WDT_TERMINATE = 2;

    /**
     * WDT_BREAK
     * This interrupts the current application (similar to Ctrl-C interruption) when the
     * watchdog timer expires.
     */
    public static final int WDT_BREAK = 3;

    /**
     * WDT_RESTART
     * When the watchdog timer expires this will interrupt the current application and
     * restart it.
     */
    public static final int WDT_RESTART = 4;

    /**
     * WDT_MESSAGE
     * When the watchdog timer expires a WM_WATCHDOG (0x11) message will be sent through
     * the system message pump. The content contains the text associated with the
     * watchdog.
     */
    public static final int WDT_MESSAGE = 5;

    /**
     * WDT_EVENT
     * Watchdog timer expiration will notify the first thread in the application that is waiting 
     * for notification using waitOnWatchdogNotify().
     */
    public static final int WDT_EVENT = 6;
    
    WatchdogEventListener eventListener;
    WatchdogThread watchdogthread;
    
    /**
     * The default constructor creates a Watchdog instance. The string representation of the
     * object is used as a reference. Note that you may supply a more descriptive text using
     * the alternative constructor.
     */
    public Watchdog() {}
    
    /** 
     * Constructor creates a Watchdog instance with defined text. This is the preferred
     * constructor.
     * 
     * @param title String to be associated with this Watchdog
     */
    public Watchdog(String title) {}
    
    /**
     * Retrieves the defined action. This returns an integer specifying the actions
     * associated with this watchdog as follows: 0=WDT_REBOOT, 1=WDT_APPLICATION,
     * 2=WDT_TERMINATE, 3=WDT_BREAK, 4=WDT_RESTART, 5=WDT_MESSAGE, and 6=WDT_EVENT.
     * 
     * @return defined action
     */
    public int getAction() {}
    
    /**
     * Defines the actions to be taken should the timer expire. This must be one of
     *  Watchdog.WDT_REBOOT - Expiration causes reboot (default). 
     *  Watchdog.WDT_APPLICATION - Application will handle expiration.
     *  Watchdog.WDT_TERMINATE - Expiration terminates the application.
     *  Watchdog.WDT_BREAK - expiration interrupts the application.
     *  Watchdog.WDT_RESTART - expiration restarts the application.
     *  Watchdog.WDT_MESSAGE - expiration issue WM_WATCH message to other applications.
     *  Watchdog.WDT_EVENT - expiration notifies waiting thread.
     * 
     * @param action specified action
     */
    public void setAction(int action) {}
    
    /**
     * Retrieves the current timer duration.
     * 
     * @return the current time duration in milliseconds
     */
    public int getDuration() {}
    
    /**
     * Sets the timer duration (60000 milliseconds is default).
     * 
     * @param duration new timer duration in milliseconds
     */
    public void setDuration(int duration) {}

    /** Retrieves the current silent flag. When set teh Watchdog event will not be logged
     * in the syslog.
     * 
     * @return the current setting of the silent flag
     */
    public boolean getSilent() {}
    
    /** Sets the silent flag. When set to true the Watchdog event will not be logged in
     * the syslog.
     * 
     * @param mode true/false as desired
     */
    public void setSilent(boolean mode) {}
    
    /**
     * Retrieves the defined text reference
     * 
     * @return defined text 
     */
    public String getText() {}
    
    /**
     * Defines the text used for example when messages are generated.
     * 
     * @param text specified text
     */
    public void setText(String text) {}
    
    /**
     * Activates (starts) the Watchdog countdown timer.
     * 
     */
    public void activate() {}
    
    /**
     * Activates (starts) the Watchdog countdown timer with specified duration.
     * 
     * @param duration new timer duration in milliseconds
     */
    public void activate(int duration) {}
    
    /**
     * Deactivates (stops) the Watchdog countdown timer.
     * 
     */
    public void deactivate() {}
    
    /**
     * Refreshes the Watchdog countdown timer.
     * 
     */
    public void refresh() {}
    
    /**
     * Check if Watchdog triggered.
     * 
     * @return TRUE if the watchdog had been triggered and caused the last action.
     */
    public boolean triggered() {}
    
    /**
     * Deletes/removes the Watchdog timer.
     * 
     */
    public void delete() {}
    
    /**
     * Set an event listener for this Watchdog.
     * 
     * @param listener WatchdogEventListener class containing the method to handle
     * this event
     */
    public void setEventListener(WatchdogEventListener listener) {}

    /**
     * Removes the event listener for this Watchdog.
     */
    public synchronized void removeEventListener() {}

    /**
     * Returns the string representation of this Watchdog object.
     * 
     * @return String representation
     */
        @Override
    public String toString() {}
    
    // Obtains a valid handle for a watchdog.
    private static native int WDbind();

    // Tells JANOS what we need to do.
    //  Commands:
    //      0 - delete
    //      1 - activate/starts timer
    //      2 - deactivate/stops timer
    //      3 - refresh/restarts timer
    private static native void WDcommand(int cmd, int handle);

    // Retrieve information
    //  Index:
    //      1 - timer duration (int)
    //      2 - triggered flag (boolean)
    //      3 - defined action (int)
    private static native int WDquery(int index, int handle);
    
    // Retireve text
    //  Index:
    //      1 - defined text
    private static native String WDtext(int index, int handle);

    // Set parameters
    // Index:
    //      1 - timer duration (int)
    //      3 - define action (int)
    private static native void WDset(int index, int value, int handle);
    
    // Set text
    //  Index:
    //      1 - defined message text
    private static native void WDdefine(int index, byte[] text, int handle);
}

class WatchdogThread extends Thread {

    private boolean eventListenerEnabled;
    private Watchdog watchdog;

    private native boolean waitOnWatchdogNotify(int handle);
    private native void stopWatchdogNotify(int handle);

    WatchdogThread() {}

    public WatchdogThread(Watchdog wdt) {}

    void stopEventListener() {}

    @Override
    public void run() {}

}
