//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 9-Jun-2012
 * -------------------------------------------------------------------------*/

package java.lang;

import com.integpg.comm.NullInputStream;
import com.integpg.comm.NullOutputStream;
import com.integpg.comm.SerialOutputStream;
import com.integpg.comm.SerialInputStream;
import com.integpg.system.*;
import java.io.*;

// Referenced classes of package java.lang:
//			Object, ArrayStoreException, Error, Exception, 
//			Integer, SecurityException, SecurityManager, String, 
//			StringBuffer, Thread, ThreadGroup, Throwable, 
//			UnsatisfiedLinkError

public final class System
{

    /**
     * The active INPUT stream typically stdin. Note that the SerialInputStream class supports
     *  echo to stdout.
     */
    public static InputStream in = new SerialInputStream(SerialInputStream.STDIN, SerialOutputStream.STDOUT);

    /**
     * The active OUTPUT stream typically stdout.
     */
    public static PrintStream out = new PrintStream(new SerialOutputStream(SerialOutputStream.STDOUT));

    /**
     * The active ERROR stream typically stderr. By default JANOS copies stderr data to the errors.log file
     *  located in the root of the file system.
     */
    public static PrintStream err = new PrintStream(new SerialOutputStream(SerialOutputStream.STDERR));

	private static SecurityManager security = null;
	private static Object lock = new Object();

	private System()
	{}

    /**
     * Copies <code>length</code> elements from the <code>src</code> array at index <code>src_position</code> to the
     * <code>dst</code> array at index <code>dst_position</code>. The <code>src</code> and <code>dst</code> arrays must be of
     * the same type. 
     *
     * @param src source array
     * @param ofs starting index in source array
     * @param dest target array
     * @param start starting index in target array
     * @param len number of elements to copy
     */
    public static void arraycopy(Object src, int ofs, Object dest, int start, int len)
	{}

    /**
     * Returns the current time in milliseconds since the January 1st 1970 at 00:00:00 GMT epoch. This
     *  is the Unix timestamp expressed in milliseconds (not seconds).
     * 
     * @return current time expressed in milliseconds
     * 
     * @see com.integpg.system.JANOS#uptimeMillis() 
     */
    public static native long currentTimeMillis();
    
    /** Facilitates using (@code Thread.sleep()} by providing the necessary exception handling.
     * 
     * @param period time in milliseconds that the thread will sleep.
     */
    public static void sleep(long period) {}
    
    /** Utilizes Thread.sleep() to pause the current process until a specified time.
     * 
     * @param time The current system time in milliseconds at which execution is to begin.
     */
    public static void waitUntil(long time) {}

    /** Terminates the current program.
     *
     * @param errorlevel Returns an integer ERRORLEVEL for command line use.
     */
    public static void exit(int errorlevel)
	{}
    
    /**
     * Suggests that JANOS performs Garbage Collection (GC) procedures.
     */
    public static native void gc();

    /** Obtain the current SecurityManager.
     *
     * @return SecurityManager object.
     */
    public static SecurityManager getSecurityManager()
	{}

    /** Obtains a value from the current process environment. This uses the
     *  JANOS.getFromCurrentEnvironment(name) method.
     *
     * @param name String specifying the name-value pair
     * @return value associated with the name
     */
    public static String getenv(String name)
	{}

    /** Sets a value in the current process environment. This uses the
     *  JANOS.setInCurrentEnvironment(name, value) method.
     *
     * @param name String defining the name for the name-value pair
     * @param value String defining the value to be assigned to the name-value pair
     */
    public static void setenv(String name, String value)
	{}
    
    /**
     * Returns the same hash code for the given object as would be returned by the default method hashCode(), whether
     * or not the given object's class overrides hashCode(). The hash code for the null reference is zero.
     * 
     * @param obj object for which the hashCode is to be calculated
     * @return the hashCode
     */
    public static native int identityHashCode(Object obj);

    /**
     * Reassigns the "standard" input stream.
     *
     * @param inputstream the new standard output stream
     */
    public static void setIn(InputStream inputstream) {}

    /**
     * Reassigns the "standard" output stream.
     *
     * @param outputstream the new standard output stream
     */
    public static void setOut(PrintStream outputstream) {}

    /**
     * Reassigns the "standard" error stream.
     *
     * @param errorstream the new standard error stream
     */
    public static void setErr(PrintStream errorstream) {}

    /** Defines a Security Manager for this process.
     *
     * @param securitymanager The SecurityManager object.
     */
    public static void setSecurityManager(SecurityManager securitymanager)
	{}

    private static native void system_exit(int i);

}
