package java.util;

import com.integpg.system.ArrayUtils;
import com.integpg.system.Timebase;

public class GregorianCalendar extends Calendar
{
    public static final int BC = 0;
    public static final int AD = 1;
    
	private static int maxParams[];

    /**
     * Constructs a default GregorianCalendar using the current time in the default time zone.
     * 
     */
    public GregorianCalendar() {}

    /**
     * Constructs a default GregorianCalendar using the specified time in the default time zone.
     * 
     */
    public GregorianCalendar(long time) {}

    /**
     * Constructs a default GregorianCalendar using the specified timezone.
     * 
     */
    public GregorianCalendar(TimeZone timezone) {}

    /**
     * Constructs a GregorianCalendar with the given date and time set for the default time zone.
     * 
     * @param year the value used to set the YEAR calendar field in the calendar.
     * @param month the value used to set the MONTH calendar field in the calendar. Month value is 0-based. e.g., 0 for January.
     * @param day the value used to set the DAY_OF_MONTH calendar field in the calendar.
     */
    public GregorianCalendar(int year, int month, int day) {}

    /**
     * Constructs a GregorianCalendar with the given date and time set for the default time zone.
     * 
     * @param year the value used to set the YEAR calendar field in the calendar.
     * @param month the value used to set the MONTH calendar field in the calendar. Month value is 0-based. e.g., 0 for January.
     * @param day the value used to set the DAY_OF_MONTH calendar field in the calendar.
     * @param hrs the value used to set the HOUR_OF_DAY calendar field in the calendar.
     * @param mins the value used to set the MINUTE calendar field in the calendar.
     */
    public GregorianCalendar(int year, int month, int day, int hrs, int mins) 	{}

    /**
     * Constructs a GregorianCalendar with the given date and time set for the default time zone.
     * 
     * @param year the value used to set the YEAR calendar field in the calendar.
     * @param month the value used to set the MONTH calendar field in the calendar. Month value is 0-based. e.g., 0 for January.
     * @param day the value used to set the DAY_OF_MONTH calendar field in the calendar.
     * @param hrs the value used to set the HOUR_OF_DAY calendar field in the calendar.
     * @param mins the value used to set the MINUTE calendar field in the calendar.
     * @param secs the value used to set the SECOND calendar field in the calendar.
     */
    public GregorianCalendar(int year, int month, int day, int hrs, int mins, int secs) {}

    /**
     * Constructs a GregorianCalendar based on the current time in the given time zone.
     * 
     * @param timezone the given time zone.
     */
    public GregorianCalendar(TimeZone timezone, long time) {}

    /**
     * Adds the specified (signed) amount of time to the given calendar field, based on the calendar's rules.
     * 
     * @param field the calendar field.
     * @param amount the amount of date or time to be added to the field.
     */
    public void add(int field, int amount) {}

    /**
     * Returns whether this Calendar represents a time after the time represented by the specified Object.
     * 
     * @param when the Object to be compared
     * @return true if the time of this Calendar is after the time represented by when; false otherwise.
     */
    public boolean after(Object when) {}

    /**
     * Returns whether this Calendar represents a time before the time represented by the specified Object.
     * 
     * @param when he Object to be compared
     * @return true if the time of this Calendar is before the time represented by when; false otherwise.
     */
    @Override
    public boolean before(Object when) {}

    /*
	private static int calculateDayOfWeek(int i, int j, int k)
	{
		if (i <= 2)
		{
			i += 12;
			k--;
		}
		int l = k % 100;
		int i1 = k / 100;
		int j1 = ((j + ((i + 1) * 26) / 10 + l + l / 4 + i1 / 4) - 2 * i1) % 7;
		if (j1 < 0)
			j1 += 7;
		return j1 != 0 ? j1 : 7;
	}
    */

    /*
	private void calculateDate(long time) {
		synchronized (this) {
			long l1 = time < 0L ? 0x253d8cL + (time - 0x5265c01L) / 0x5265c00L : 0x253d8cL + time / 0x5265c00L;
			long l3;
			if (time >= 0xfffff4e2f964ac00L) {
				long l2 = (4L * l1 - 0x71f741L) / 0x23ab1L;
				l3 = (l1 + 1525L + l2) - l2 / 4L;
			} else {
				l3 = l1 + 1524L;
			}
			long l4 = 6680L + (long)(((double)(float)(l3 - 0x253abeL << 2) - 488.39999999999998D) / 1461D);
			long l5 = (1461L * l4) / 4L;
			long l6 = (10000L * (l3 - l5)) / 0x4ab51L;
			int Day = (int)(l3 - l5 - (0x4ab51L * l6) / 10000L);
			int i = (int)(l6 - 1L);
			i = --i % 12;
			if (i < 0)
				i = -i;
			int k = (int)(l4 - 4715L);
			if (i > 1)
				k--;

            int params[] = super.tzParams;
			boolean paramSet[] = super.isParamSet;
			if (k <= 0)
			{
				params[ERA] = 0;
				params[YEAR] = 1 - k;
			} else
			{
				params[ERA] = 1;
				params[YEAR] = k;
			}
			params[MONTH] = i;
			params[DAY_OF_MONTH] = Day;
			int DoWeek = (int)((l1 + 1L) % 7L);
			DoWeek += DoWeek >= 0 ? 1 : 8;
			params[DAY_OF_WEEK] = DoWeek;
            
			int DoYear = 0;
			for (int k1 = 0; k1 < i; k1++)
				DoYear += 0xeefbb3 >> (k1 << 1) & 3 | 0x1c;

			if (i > 2 && leapYear(k))
				DoYear += Day + 1;
			else
				DoYear += Day;
			params[DAY_OF_YEAR] = DoYear;
			params[WEEK_OF_YEAR] = getWeekNumber(DoYear, DoWeek);
			params[WEEK_OF_MONTH] = getWeekNumber(Day, DoWeek);
			params[DAY_OF_WEEK_IN_MONTH] = (Day - 1) / 7 + 1;
			
            paramSet[ERA] = true;
			paramSet[YEAR] = true;
			paramSet[MONTH] = true;
			paramSet[DAY_OF_MONTH] = true;
			paramSet[DAY_OF_WEEK] = true;
			paramSet[DAY_OF_YEAR] = true;
			paramSet[WEEK_OF_YEAR] = true;
			paramSet[WEEK_OF_MONTH] = true;
			paramSet[DAY_OF_WEEK_IN_MONTH] = true;
		}
	}
    */

    /**
     *
     */
    @Override
    protected void computeFields() {}
    private static native int[] calcFields(long time, byte[] id);

    @Override
    protected void computeTime()
	{}
    private static native long calcTime(int[] fields, byte[] id);

    @Override
	public boolean equals(Object obj)
	{}

    /**
     *
     * @param i ?
     * @return ?
     */
    @Override
    public int getGreatestMinimum(int i)
	{}

    /**
     *
     * @param i ?
     * @return ?
     */
    @Override
    public int getLeastMaximum(int i) {}

    /**
     *
     * @param i ?
     * @return ?
     */
    @Override
    public int getMaximum(int i) {}

    /**
     *
     * @param i ?
     * @return ?
     */
    @Override
    public int getMinimum(int i) {}

    /*
	private int getWeekNumber(int doy, int dow)
	{
		int k = ((dow - getFirstDayOfWeek() - doy) + 1) % 7;
		if (k < 0)
			k += 7;
		int l = ((doy + k) - 1) / 7;
		if (7 - k >= getMinimalDaysInFirstWeek())
			l++;
		return l;
	}
    */

    @Override
	public synchronized int hashCode() {}

    /*
    // Returns TRUE if the supplied year is a Leap Year
	private boolean leapYear(int year) {
		if (year % 400 == 0)
			return true;
		if (year % 100 == 0)
			return false;
		return year % 4 == 0;
	}
    */

    @Override
    public void roll(int i, boolean flag) {}
}
