
package java.lang;

import java.util.Random;

// Referenced classes of package java.lang:
//			Object, Double, Float, Integer, 
//			Long

/**
 *
 * @author Bruce Cloutier
 */

public final class Math
{

    /**
     * E
     */
    public static final double E = 2.7182818284590451D;

    /**
     * PI
     */
    public static final double PI = 3.1415926535897931D;

    /**
     * LN10
     */
    public static final double LN10 = 2.302585092994046D;

    /**
     * LN2
     */
    public static final double LN2 = 0.6931471805599453D;

    /**
     * LN10E
     */
    public static final double LN10E = 0.4342944819032518D;

    /**
     * LN2E
     */
    public static final double LN2E = 1.4426950408889634D;

    /**
     * SQRT1_2
     */
    public static final double SQRT1_2 = 0.7071067811865476D;

    /**
     * SQRT2
     */
    public static final double SQRT2 = 1.4142135623730951D;

	private static Random rand;
	
    // Cannot instantiate. All functions are statically accessed.
	private Math()
	{}

    /** 
     * The Math.abs() function returns the absolute value of a number.
     *
     * @param x a number
     * @return a positive value x
     */
    public static double abs(double x) {}

    /** 
     * The Math.abs() function returns the absolute value of a number.
     *
     * @param x a number
     * @return a positive value x
     */
    public static float abs(float x) {}

    /** 
     * The Math.abs() function returns the absolute value of a number.
     *
     * @param x a number
     * @return a positive value x
     */
    public static int abs(int x) {}

    /** 
     * The Math.abs() function returns the absolute value of a number.
     *
     * @param x a number
     * @return a positive value x
     */
    public static long abs(long x) {}

    /** 
     * The Math.ceil() function returns the smallest integer greater than 
     * or equal to a given number.
     *
     * @param x a number
     * @return the smallest integer greater than or equal to the number
     */
    public static double ceil(double x) {}

    /** 
     * The Math.floor() function returns the largest integer less than 
     * or equal to a given number.
     *
     * @param x a number
     * @return largest integer less than or equal to the number
     */
    public static double floor(double x) {}

    /** 
     * The Math.max() function returns the largest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the largest of the numbers
     */
    public static double max(double a, double b) {}

    /** 
     * The Math.max() function returns the largest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the largest of the numbers
     */
    public static float max(float a, float b) {}

    /** 
     * The Math.max() function returns the largest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the largest of the numbers
     */
    public static int max(int a, int b) {}

    /** 
     * The Math.max() function returns the largest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the largest of the numbers
     */
    public static long max(long a, long b) {}

    /** 
     * The Math.min() function returns the smallest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the smallest of the two numbers
     */
    public static double min(double a, double b) {}

    /** 
     * The Math.min() function returns the smallest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the smallest of the two numbers
     */
    public static float min(float a, float b) {}

    /** 
     * The Math.min() function returns the smallest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the smallest of the two numbers
     */
    public static int min(int a, int b) {}

    /** 
     * The Math.min() function returns the smallest of two numbers.
     *
     * @param a a number
     * @param b a number
     * @return the smallest of the two numbers
     */
    public static long min(long a, long b) {}

    /** 
     * The Math.random() function returns a floating-point, pseudo-random number 
     * in the range [0, 1) that is, from 0 (inclusive) up to but not 
     * including 1 (exclusive), which you can then scale to your desired range. The 
     * implementation selects the initial seed to the random number generation 
     * algorithm; it cannot be chosen or reset by the user.
     *
     * @return a random number
     */
    public static synchronized double random() {}

    /** 
     * The Math.round() function returns the value of a number rounded to the 
     * nearest integer. If the fractional portion of number is 0.5 or greater, 
     * the argument is rounded to the next higher integer. If the fractional 
     * portion of number is less than 0.5, the argument is rounded to the next 
     * lower integer.
     *
     * @param d a number
     * @return parameter d rounded to the nearest integer
     */
    public static long round(double d) {}

    /** 
     * The Math.round() function returns the value of a number rounded to the 
     * nearest integer. If the fractional portion of number is 0.5 or greater, 
     * the argument is rounded to the next higher integer. If the fractional 
     * portion of number is less than 0.5, the argument is rounded to the next 
     * lower integer.
     *
     * @param x a number
     * @return x rounded to the nearest integer
     */
    public static int round(float x) {}

    /** 
     * The Math.sqrt() function returns the square root of a number. If the 
     * value of x is negative, Math.sqrt() returns NaN.
     *
     * @param x a number
     * @return the square root of x
     */
    public static native double sqrt(double x);

    /** 
     * The Math.sin() method returns a numeric value between -1 and 1, which 
     * represents the sine of the angle given in radians.
     *
     * @param x an angle (in radians)
     * @return sin(x)
     */
    public static native double sin(double x);

    /** 
     * The Math.cos() method returns a numeric value between -1 and 1, which 
     * represents the cosine of the angle.
     *
     * @param x an angle (in radians)
     * @return cos(x)
     */
    public static native double cos(double x);

    /** 
     * The Math.tan() method returns a numeric value that represents the tangent of 
     * the angle.
     *
     * @param x an angle (in radians)
     * @return tan(x)
     */
    public static native double tan(double x);

    /** 
     * The Math.asin() method returns a numeric value between - π/2  and  π/2  radians 
     * for x between -1 and 1. If the value of x is outside this range, it returns NaN.
     *
     * @param x a number between -1 and 1 (inclusive)
     * @return sin(x) angle (in radians)
     */
    public static native double asin(double x);

    /** 
     * The Math.acos() method returns a numeric value between 0 and π radians for x 
     * between -1 and 1. If the value of x is outside this range, it returns NaN.
     *
     * @param x a number between -1 and 1 (inclusive)
     * @return cos(x) angle (in radians)
     */
    public static native double acos(double x);

    /** 
     * The Math.atan() method returns a numeric value between - π/2  and  π/2  radians.
     *
     * @param x a number
     * @return atan(x) angle (in radians)
     */
    public static native double atan(double x);

    /** 
     * The Math.atan2() method returns a numeric value between -π and π representing the 
     * angle theta of an (x, y) point. This is the counterclockwise angle, measured in 
     * radians, between the positive X axis, and the point (x, y). Note that the arguments 
     * to this function pass the y-coordinate first and the x-coordinate second.
     *
     * @param x x ordinate
     * @param y y ordinate
     * @return atan2(y, x)
     */
    public static native double atan2(double y, double x);

    /** 
     * The Math.pow() function returns the base to the exponent power. That is the
     * value of a raised to the b power.
     *
     * @param a the base 
     * @param b the exponent
     * @return a raised to b
     */
    public static native double pow(double a, double b);

    /** 
     * The Math.exp() function returns e raised to x, where x is the argument, and e 
     * is Euler's number (also known as Napier's constant), the base of the natural logarithms.
     *
     * @param x a number
     * @return e raised to the power x
     */
    public static native double exp(double x);

    /** 
     * The Math.log() function returns the natural logarithm (base e) of a number.
     *
     * @param x a number
     * @return the logarithm (base e) of x
     */
    public static native double log(double x);

    /** 
     * The Math.log10() function returns the base 10 logarithm of a number.
     *
     * @param x a number
     * @return the logarithm (base 10) of x
     */
    public static native double log10(double x);

    /**
     * Computes the remainder operation on two arguments as prescribed 
     * by the IEEE 754 standard.
     * The remainder value is mathematically equal to 
     * <code>f1&nbsp;-&nbsp;f2</code>&nbsp;&times;&nbsp;<i>n</i>,
     * where <i>n</i> is the mathematical integer closest to the exact 
     * mathematical value of the quotient <code>f1/f2</code>, and if two 
     * mathematical integers are equally close to <code>f1/f2</code>, 
     * then <i>n</i> is the integer that is even. If the remainder is 
     * zero, its sign is the same as the sign of the first argument. 
     * Special cases:
     * <ul><li>If either argument is NaN, or the first argument is infinite, 
     * or the second argument is positive zero or negative zero, then the 
     * result is NaN.
     * <li>If the first argument is finite and the second argument is 
     * infinite, then the result is the same as the first argument.</ul>
     *
     * @param   f1   the dividend.
     * @param   f2   the divisor.
     * @return  the remainder when <code>f1</code> is divided by
     *          <code>f2</code>.
     */
    public static native double IEEEremainder(double f1, double f2);
    
}
