/*
 * Simple ArrayList class implementation.
 */
package java.util;

import com.integpg.system.ArrayUtils;

/**
 *
 * @author Bruce Cloutier
 * 
 * @param <E> Type
 */
public class ArrayList<E> implements Iterable<E>, Cloneable {
    
    /**
     * This is the array buffer.
     */
    private Object[] data;
    
    /**
     * The count of elements in the array buffer.
     */
    private int size;
    
    private static final Object[] NODATA = {};    
    private static final int CAPACITY_INCREMENT = 16;
    
    /**
     * Constructor creates a default empty array list.
     */
    public ArrayList() {}
    
    /**
     * Constructor to create an array list of some initial size
     * @param capacity 
     */
    public ArrayList(int capacity) {}

    /**
     * Constructor creates an array list from an existing basic array. Makes a copy of the
     * supplied array.
     * 
     * @param arr existing basic array.
     */
    public ArrayList(Object[] arr) {}
    
    /**
     * Constructor creates an array list from a portion of an existing array.
     * 
     * @param arr existing basic array
     * @param ofs offset into the array
     * @param len length of new array list
     */    
    public ArrayList(Object[] arr, int ofs, int len) {}

    /**
     * Clones the array list.
     * 
     * @return new ArrayList object
     */
    public synchronized Object clone() {}

    /**
     * Returns the count of elements stored in the array list.
     * 
     * @return number of elements
     */
    public int size() {}
    
    /**
     * Indicates an empty array list.
     * 
     * @return {@code true} if the array list is empty
     */
    boolean isEmpty() {}

    /**
     * Clears the array list. It will be empty.
     */
    public void clear() {}
    
    /**
     * Obtains a copy of the array list.
     * 
     * @return new basic array containing the array list contents
     */
    public Object[] toArray() {}
    
    /**
     * Obtain the element at the provided index.
     * 
     * @param index object in the array list to return
     * @return the object at the specified position
     */
    public E get(int index) {}
    
    /**
     * Stores the provided item in a range of the array list. The array list is expanded as needed.
     * 
     * @param index staring index for the fill
     * @param cnt total number of item references to store
     * @param item the item to be stored
     */
    public void fill(int index, int cnt, E item) {}
    
    /**
     * Stores a new item at the specified index. The array list is expanded as needed.
     * 
     * @param index position to update
     * @param item the item to be stored
     * @return the prior content of the specified location
     */
    public E set(int index, E item) {}
    
    /**
     * Adds the item to the end of the array list.
     * 
     * @param item item to be appended
     * @return {@code true} if successful
     */
    public boolean add(E item) {}
    
    /**
     * Inserts the supplied item at the specified position.
     * 
     * @param index position of insertion
     * @param item item to be stored
     */
    public void add(int index, E item) {}
    
    /**
     * Removes the item at the specified index.
     * 
     * @param index position of item to remove
     * @return the removed item
     */
    public E remove(int index) {}
    
    /** 
     * Removes the first occurrence of an item.
     * 
     * @param item item to be removed
     * @return {@code true} if the item was detected and removed.
     */
    public boolean remove(Object item) {}
    
    /**
     * Returns the current capacity of the array list and not the count of elements.
     * 
     * @return size of the internal array
     */
    public int capacity() {}
    
    /**
     * Ensures that the array list has enough capacity.
     * 
     * @param cnt requested new size for the array list
     */
    public void ensureCapacity(int cnt) {}
    
    /**
     * Trims the array list to fit only the existing data. This can be used to save
     * memory.
     */
    public void trimToSize() {}
    
    /**
     * Forces the internal array to a specific size. If this will truncate data
     * if less than the current element count.
     * 
     * @param cnt desired size.
     */
    public void setSize(int cnt) {}
    
    /** 
     * Indicates whether or not the item exists in the array list.
     * 
     * @param item the item to look for
     * @return {@code true} if the item exists.
     */
    public boolean contains(Object item) {}

    /**
     * Returns the index of the first matching item.
     * 
     * @param item to be matched
     * @return index of the item or -1 if not found
     */
    public int indexOf(Object item) {}

    /**
     * Returns the the index of the first matching item located at or after
     * the supplied index.
     * 
     * @param item to be matched
     * @param index starting point
     * @return index of the located item or -1 otherwise
     */
    public int indexOf(Object item, int index) {}
    
    /**
     * Returns the last occurrence of the supplied item.
     * 
     * @param item item to search for
     * @return last position it can be found or -1 otherwise
     */
    public int lastIndexOf(Object item) {}
    
    /**
     * Returns the last occurrence of the supplied item up to and including the
     * supplied index.
     * 
     * @param item item to search for
     * @param index the position to search back from (inclusive)
     * @return the index of the item if it exists in the array list at or prior to the supplied index
     */
    public int lastindexOf(Object item, int index) {}
    
    /**
     * Basic requirement to make this class work with for-each.
     * @return 
     */
    @Override
    public Iterator<E> iterator() {}
    
    private class ArrayIterator implements Iterator<E> {}

}
