//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/**
 * Creates an input stream that either compresses or decompresses the initial byte array.
 */
package com.integpg.system;

/**
 *
 * @author Bruce Cloutier
 */
public class Compressor {
    
    /**
     * Static method decompresses the supplied byte array. The byte array must contain
     *  the entire compressed data.
     * 
     * @param data compressed representation of the desired data
     * @return byte[] of uncompressed data or NULL if the action fails.
     */
    public static native byte[] inflate(byte[] data);

    /**
     * Static method compresses the supplied byte array. 
     * 
     * @param data byte[] containing the data to be compressed
     * @return Compressed representation of the data as a byte[]
     */
    public static native byte[] deflate(byte[] data);
}
