package java.util;


// Referenced classes of package java.util:
//			Enumeration

/**
 * The <code>Dictionary</code> class is the abstract parent of any
 * class, such as <code>Hashtable</code>, which maps keys to values.
 * 
 * @param <K> Type used with Keys
 * @param <V> Type used with Values
 */
public abstract class Dictionary<K,V>
{

    /**
     * Sole Constructor.
     */
    public Dictionary()
	{}

    /**
     * Returns an enumeration of the values in this dictionary.
     *
     * @return  an enumeration of the values in this dictionary.
     */
    public abstract Enumeration<V> elements();

    /**
     * Returns the value to which the key is mapped in this dictionary.
     * 
     * @return the value to which the key is mapped in this dictionary;
     * @param key a key in this dictionary.
     */
    public abstract V get(K key);

    /**
     * Tests if this dictionary maps no keys to value.
     *
     * @return  <code>true</code> if this dictionary maps no keys to values;
     *          <code>false</code> otherwise.
     */
    public abstract boolean isEmpty();

    /**
     * Returns an enumeration of the keys in this dictionary.
     *
     * @return  an enumeration of the keys in this dictionary.
     */
    public abstract Enumeration<K> keys();

    /**
     * Maps the specified <code>key</code> to the specified
     * <code>value</code> in this dictionary.
     *
     * @param key the hashtable key.
     * @param value the value.
     * @return the previous value to which the <code>key</code> was mapped
     *             in this dictionary, or <code>null</code> if the key did not
     *             have a previous mapping.
     */
    public abstract V put(K key, V value);

    /**
     * Removes the <code>key</code> (and its corresponding
     * <code>value</code>) from this dictionary.
     *
     * @param key the key that needs to be removed.
     * @return  the value to which the <code>key</code> had been mapped in this
     *          dictionary, or <code>null</code> if the key did not have a
     *          mapping.
     */
    public abstract V remove(K key);

    /**
     * Returns the number of entries (distinct keys) in this dictionary.
     *
     * @return  the number of keys in this dictionary.
     */
    public abstract int size();
}
