package java.lang;

// Referenced classes of package java.lang:
//			Object

/**
 * This interface imposes a ordering on the objects of each class that
 * implements it.
 *
 * @param <T> the type of objects that this object may be compared to
 *
 */
public interface Comparable<T> {

    /**
     * Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.
     *
     * @param obj the object to be compared.
     * @return  a negative integer, zero, or a positive integer as this object
     *          is less than, equal to, or greater than the specified object.
     *
     * @throws NullPointerException if the specified object is null
     * @throws ClassCastException if the specified object's type prevents it
     *         from being compared to this object.
     */
    public abstract int compareTo(T obj);
}
