/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package java.util.regex;

/**
 *
 * @author Bruce
 */
public final class Matcher extends Object
    implements MatchResult
{

    private Pattern pattern = null;
    private String string = null;
    private int start = 0;
    private int end = 0;
    private int[] groups_start = null;
    private int[] groups_end = null;
    
    // constructor
    Matcher()
    {}

    Matcher(Pattern p, String str) {}
    
    /**
     * Returns the regex machine used by this matcher.
     * 
     * @return instance of this machine
     */
    public Pattern pattern() {}
    
    /**
     * Changes the pattern used by this matcher.
     * 
     * @param p new pattern
     * @return instance of this machine using the new pattern
     */
    public Matcher usePattern(Pattern p) {}

    /**
     * Returns true if and only if the string is matched by the pattern.
     * 
     * @return true on match
     */
    public boolean matches() {}
    
    private static native int[] regexBeg(int machine);
    private static native int[] regexEnd(int machine);
    
    /**
     * Returns true if the string has at least one match by the pattern.
     * 
     * @return true if there is a match
     */
    public boolean lookingAt() {}

    /**
     * Find next match (if any) in the string. This starts at the beginning or
     * immediately after that last match. The method returns true if a match is found.
     * 
     * @return true if, and only if, a subsequence of the input sequence matches this matcher's pattern
     */
    public boolean find() {}
    
    /**
     * Find next match (if any) in the string. This starts at the defined offset.
     * The method returns true if a match is found.
     * 
     * @param ofs offset indicating where to start the search
     * @return true if a match was found
     */
    public boolean find(int ofs) {}
    
    /**
     * Reset this matcher.
     * 
     * @return this instance of the matcher
     */
        public Matcher reset() {}
    
    /**
     * Reset this matcher with a new input string.
     * 
     * @param str new pattern
     * @return instance of this machine now ready to use the new pattern
     */
    public Matcher reset(String str) {}
    
    /**
     * Returns the number of capture groups.
     * 
     * @return count of capture groups
     */
    @Override
    public int groupCount() {}
    
    private static native boolean regexMatch(int machine, String str, int ofs, int len);

    /**
     * Returns the input subsequence captured by the previous match.
     * 
     * @return String containing the matched input data
     */
    @Override
    public String group() {}

    /**
     * Returns the input sequence captured by the given group.
     * 
     * @param group group index
     * @return string containing the matched input data
     * @throws IndexOutOfBoundsException If there is no capturing group in the pattern with the given index
     * @throws IllegalStateException If no match has yet been attempted, or if the previous match operation failed
     */
    @Override
        public String group(int group) 
            throws IndexOutOfBoundsException, IllegalStateException {}
    
    /**
     * Returns the input sequence captured by the named capturing group.
     * 
     * @param name group name
     * @return null 
     */
    public String group(String name) {}

    /**
     * Returns the offset of the last match.
     * 
     * @return offset of the last successful match
     */
    @Override
    public int start() {}

    /**
     * Returns the start index of the subsequence captured by the given group.
     * 
     * @param group group index
     * @return starting index of match
     * @throws IndexOutOfBoundsException If there is no capturing group in the pattern with the given index
     * @throws IllegalStateException If no match has yet been attempted, or if the previous match operation failed
     */
    @Override
    public int start(int group) 
            throws IndexOutOfBoundsException, IllegalStateException {}
    
    /**
     * Returns the offset after the last match.
     * 
     * @return offset to position following the last match
     */
    @Override
    public int end() {}

    /**
     * Returns the index after the subsequence captured by the given group.
     * 
     * @param group group index
     * @return index of position following the match
     * @throws IndexOutOfBoundsException If there is no capturing group in the pattern with the given index
     * @throws IllegalStateException If no match has yet been attempted, or if the previous match operation failed
     */
    @Override
    public int end(int group)
            throws IndexOutOfBoundsException, IllegalStateException {}
    
    /**
     * Replaces every matched subsequence.
     * 
     * @param replacement used to replace matching data
     * @return result of the replacement
     */
    public String replaceAll(String replacement) {}
        
    /**
     * Replaces the first matched subsequence.
     * 
     * @param replacement used to replace the matching data
     * @return result of the replacement
     */
    public String replaceFirst(String replacement) {}
    
    private String _replace(String replacement, boolean all) {}
    
    private static native String regexReplstr(int machine, String repl);

    /**
     * Returns the match state of this matcher.
     * 
     * @return state
     */
    public MatchResult toMatchResult() {}
    
}
