package java.io;


// Referenced classes of package java.io:
//			FilterInputStream, IOException, InputStream

/**
 *
 * @author Bruce
 */

public class BufferedInputStream extends FilterInputStream
{

    protected byte buf[];
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;

    /**
     * Creates a BufferedInputStream and saves its argument, the input stream in, for later use.
     * 
     * @param in the underlying input stream.
     */
    public BufferedInputStream(InputStream in)
	{}

    /**
     * Creates a BufferedInputStream with the specified buffer size, and saves 
     * its argument, the input stream in, for later use.
     * 
     * @param in the underlying input stream.
     * @param size the buffer size.
     */
    public BufferedInputStream(InputStream in, int size)
	{}

    /**
     * Returns an estimate of the number of bytes that can be read (or skipped over) from this input 
     * stream without blocking by the next invocation of a method for this input stream. The next 
     * invocation might be the same thread or another thread. A single read or skip of this many 
     * bytes will not block, but may read or skip fewer bytes.
     * 
     * @return an estimate of the number of bytes that can be read (or skipped over) from this input stream without blocking.
     * @throws IOException if this input stream has been closed by invoking its close() method, or an I/O error occurs.
     */
    @Override
    public synchronized int available()
		throws IOException
	{}

    /**
     * Mark the current position in the stream.
     * 
     * @param rlimit the maximum limit of bytes that can be read before the mark position becomes invalid.
     */
    @Override
    public synchronized void mark(int rlimit)
	{}

    /**
     * Tests if this input stream supports the mark and reset methods.
     * 
     * @return  boolean indicating if this stream type supports the mark and reset methods.
     */
    @Override
    public boolean markSupported()
	{}

    /**
     * Reads the next byte of data.
     * 
     * @return the next byte of data, or -1 if the end of the stream is reached.
     * @throws IOException  if this input stream has been closed by invoking its close() method, or an I/O error occurs.
     */
    @Override
    public synchronized int read()
		throws IOException
	{}

    /**
     * Reads bytes from this byte-input stream into the specified byte array, starting at the given offset.
     * 
     * @param arr destination array
     * @param ofs offset at which to start storing bytes
     * @param len maximum number of bytes to read
     * @return the number of bytes read, or -1 if the end of the stream has been reached.
     * @throws IOException if this input stream has been closed by invoking its close() method, or an I/O error occurs.
     */
    @Override
    public synchronized int read(byte arr[], int ofs, int len)
		throws IOException
	{}

	private void refillBuffer()
		throws IOException
	{}

    /**
     * The stream is positioned to the last mark.
     * 
     * @throws IOException if this stream has not been marked or, if the mark has been invalidated, 
     * or the stream has been closed by invoking its close() method, or an I/O error occurs.
     */
    @Override
    public synchronized void reset()
		throws IOException
	{}

    /**
     * Skip a number of bytes from the input stream.
     * 
     * @param cnt the number of bytes to be skipped.
     * @return the actual number of bytes skipped.
     * @throws IOException  if the stream does not support seek, or if this input stream has been 
     * closed by invoking its close() method, or an I/O error occurs.
     */
    @Override
    public synchronized long skip(long cnt)
		throws IOException
	{}
}
