package com.integpg.io;

import java.io.*;


/*
 * Note some weird Java-UTF8, where the value 0 is encoded as 2 bytes, rather than 1.  
 *  this allows java.io.RandomAccessFile and java.io.DataOutputStream to use this class.
 *  Not accommodated until there is evidence of the issue.
 */
public class CharToByteUTF8
   extends CharToByteConverter
{

    /**
     *
     * @param src ?
     * @param srcStart ?
     * @param dst ?
     * @param dstStart ?
     * @param len ?
     * @return ?
     */
    public static native int convertCharToUTF8(char[] src, int srcStart, byte[] dst, int dstStart, int len);

    /**
     *
     * @param str ?
     * @param offset ?
     * @param dst ?
     * @param dstStart ?
     * @param len ?
     * @return ?
     */
    public static int convertStringToUTF8(String str, int offset, byte[] dst, int dstStart, int len)
    {}

    /**
     * UTF-8 encodes characters in a multi-byte format consisting of from 1 to 4 bytes. When a char[] is
     *  converted the resulting byte[] has more elements. We therefore need to know in advance the
     *  size of the required destination buffer. This returns that.
     * @param src char[] to be encoded
     * @param srcStart offset in char[] to start
     * @param len number of chars to encode
     * @return number of bytes required
     */
    public static native int getCharToUTF8Length(char[] src, int srcStart, int len);

    /**
     *
     * @param str String containing the characters to be converted
     * @param offset offset in the string to start
     * @param len number of characters to be converted
     * @return number of bytes required
     */
    public static int getStringToUTF8Length(String str, int offset, int len)
    {}

   /**
    *
     * @return  ?
    */
   @Override
   public int getMaxByteCount (char[] forThis, int start, int end)
   {}

   /**
    *
     * @return  ?
     * @throws java.io.CharConversionException ?
    */
   @Override
   public int convert (char[] src, int srcStart, int srcEnd, byte[] dst,
                       int dstStart, int dstEnd)
      throws CharConversionException
   {}

   /**
    *
     * @param length ?
     * @return  ?
    */
   @Override
   public int flush (byte[] buff, int start, int length)
   {}

   /**
    *
     * @return  ?
    */
   @Override
   public String getName ()
   {}

    /**
     *
     * @param str ?
     * @param writer ?
     * @return ?
     * @throws IOException ?
     */
    public static int write(String str, DataOutput writer)
        throws IOException
   {}
}
